/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.privilege;

import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.security.privilege.PrivilegeDefinitionWriter;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrivilegeInitializer
implements RepositoryInitializer,
PrivilegeConstants {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeInitializer.class);
    private final RootProvider rootProvider;

    PrivilegeInitializer(@Nonnull RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    @Override
    public void initialize(@Nonnull NodeBuilder builder) {
        NodeBuilder system = builder.child("jcr:system");
        system.setProperty("jcr:primaryType", "rep:system", Type.NAME);
        if (!system.hasChildNode("rep:privileges")) {
            NodeBuilder privileges = system.child("rep:privileges");
            privileges.setProperty("jcr:primaryType", "rep:Privileges", Type.NAME);
            NodeState base = ModifiedNodeState.squeeze(builder.getNodeState());
            MemoryNodeStore store = new MemoryNodeStore(base);
            try {
                Root systemRoot = this.rootProvider.createSystemRoot(store, null);
                new PrivilegeDefinitionWriter(systemRoot).writeBuiltInDefinitions();
            }
            catch (RepositoryException e) {
                log.error("Failed to register built-in privileges", (Throwable)e);
                throw new RuntimeException(e);
            }
            NodeState target = store.getRoot();
            target.compareAgainstBaseState(base, new ApplyDiff(builder));
        }
    }
}

