/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.principal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrincipalProviderImpl
implements PrincipalProvider {
    private static final Logger log = LoggerFactory.getLogger(PrincipalProviderImpl.class);
    private final UserManager userManager;

    PrincipalProviderImpl(@Nonnull Root root, @Nonnull UserConfiguration userConfiguration, @Nonnull NamePathMapper namePathMapper) {
        this.userManager = userConfiguration.getUserManager(root, namePathMapper);
    }

    @Override
    public Principal getPrincipal(@Nonnull String principalName) {
        Authorizable authorizable = this.getAuthorizable(new PrincipalImpl(principalName));
        if (authorizable != null) {
            try {
                return authorizable.getPrincipal();
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
        }
        return "everyone".equals(principalName) ? EveryonePrincipal.getInstance() : null;
    }

    @Override
    @Nonnull
    public Set<Group> getGroupMembership(@Nonnull Principal principal) {
        Authorizable authorizable = this.getAuthorizable(principal);
        if (authorizable == null) {
            return Collections.emptySet();
        }
        return this.getGroupMembership(authorizable);
    }

    @Override
    @Nonnull
    public Set<? extends Principal> getPrincipals(@Nonnull String userID) {
        HashSet<Principal> principals = new HashSet<Principal>();
        try {
            Authorizable authorizable = this.userManager.getAuthorizable(userID);
            if (authorizable != null && !authorizable.isGroup()) {
                principals.add(authorizable.getPrincipal());
                principals.addAll(this.getGroupMembership(authorizable));
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        return principals;
    }

    @Override
    @Nonnull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        try {
            Iterator<Authorizable> authorizables = this.findAuthorizables(nameHint, searchType);
            Iterator principals = Iterators.transform((Iterator)Iterators.filter(authorizables, (Predicate)Predicates.notNull()), (Function)new AuthorizableToPrincipal());
            if (PrincipalProviderImpl.matchesEveryone(nameHint, searchType)) {
                principals = Iterators.concat((Iterator)principals, (Iterator)Iterators.singletonIterator((Object)EveryonePrincipal.getInstance()));
                return Iterators.filter((Iterator)principals, (Predicate)new EveryonePredicate());
            }
            return principals;
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
            return Collections.emptyIterator();
        }
    }

    @Override
    @Nonnull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    private Authorizable getAuthorizable(Principal principal) {
        try {
            return this.userManager.getAuthorizable(principal);
        }
        catch (RepositoryException e) {
            log.debug("Error while retrieving principal: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Set<Group> getGroupMembership(Authorizable authorizable) {
        HashSet<Group> groupPrincipals = new HashSet<Group>();
        try {
            Iterator<org.apache.jackrabbit.api.security.user.Group> groups = authorizable.memberOf();
            while (groups.hasNext()) {
                Principal grPrincipal = groups.next().getPrincipal();
                if (!(grPrincipal instanceof Group)) continue;
                groupPrincipals.add((Group)grPrincipal);
            }
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage());
        }
        groupPrincipals.add(EveryonePrincipal.getInstance());
        return groupPrincipals;
    }

    private Iterator<Authorizable> findAuthorizables(final @Nullable String nameHint, final int searchType) throws RepositoryException {
        Query userQuery = new Query(){

            @Override
            public <T> void build(QueryBuilder<T> builder) {
                builder.setCondition(builder.like("@rep:principalName", PrincipalProviderImpl.buildSearchPattern(nameHint)));
                builder.setSelector(AuthorizableType.getType(searchType).getAuthorizableClass());
            }
        };
        return this.userManager.findAuthorizables(userQuery);
    }

    private static String buildSearchPattern(String nameHint) {
        if (nameHint == null) {
            return "%";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        sb.append(nameHint.replace("%", "\\%").replace("_", "\\_"));
        sb.append('%');
        return sb.toString();
    }

    private static boolean matchesEveryone(String nameHint, int searchType) {
        return searchType != 1 && (nameHint == null || "everyone".contains(nameHint));
    }

    private static final class EveryonePredicate
    implements Predicate<Principal> {
        private boolean servedEveryone = false;

        private EveryonePredicate() {
        }

        public boolean apply(@Nullable Principal principal) {
            String pName;
            String string = pName = principal == null ? null : principal.getName();
            if ("everyone".equals(pName)) {
                if (this.servedEveryone) {
                    return false;
                }
                this.servedEveryone = true;
                return true;
            }
            return true;
        }
    }

    private static final class AuthorizableToPrincipal
    implements Function<Authorizable, Principal> {
        private AuthorizableToPrincipal() {
        }

        public Principal apply(@Nullable Authorizable authorizable) {
            if (authorizable != null) {
                try {
                    return authorizable.getPrincipal();
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

