/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.security.authorization.permission.ReadStatus;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;

final class RepoPolicyTreePermission
implements TreePermission {
    private RepositoryPermission repoPermission;
    private ReadStatus readStatus;

    RepoPolicyTreePermission(RepositoryPermission repoPermission) {
        this.repoPermission = repoPermission;
    }

    TreePermission getChildPermission() {
        return this;
    }

    @Override
    @Nonnull
    public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
        return this.getChildPermission();
    }

    @Override
    public boolean canRead() {
        return this.getReadStatus().allowsThis();
    }

    @Override
    public boolean canRead(@Nonnull PropertyState property) {
        return this.getReadStatus().allowsThis();
    }

    @Override
    public boolean canReadAll() {
        return this.getReadStatus().allowsAll();
    }

    @Override
    public boolean canReadProperties() {
        return this.getReadStatus().allowsProperties();
    }

    @Override
    public boolean isGranted(long permissions) {
        return this.repoPermission.isGranted(permissions);
    }

    @Override
    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return this.repoPermission.isGranted(permissions);
    }

    private ReadStatus getReadStatus() {
        if (this.readStatus == null) {
            boolean canRead = this.repoPermission.isGranted(128L);
            this.readStatus = canRead ? ReadStatus.ALLOW_ALL : ReadStatus.DENY_ALL;
        }
        return this.readStatus;
    }
}

