/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;

class PrincipalPermissionEntries {
    private static int MAX_SIZE = Integer.getInteger("oak.PrincipalPermissionEntries.maxSize", 1000);
    private boolean fullyLoaded;
    private Map<String, Collection<PermissionEntry>> entries = new HashMap<String, Collection<PermissionEntry>>();
    private final Map<String, Boolean> emptyPaths = new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > MAX_SIZE;
        }
    };

    PrincipalPermissionEntries() {
    }

    long getSize() {
        return this.entries.size() + this.emptyPaths.size();
    }

    boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    @Nonnull
    Map<String, Collection<PermissionEntry>> getEntries() {
        return this.entries;
    }

    @Nullable
    Collection<PermissionEntry> getEntriesByPath(@Nonnull String path) {
        return this.emptyPaths.containsKey(path) ? Collections.emptySet() : this.entries.get(path);
    }

    void putEntriesByPath(@Nonnull String path, @Nonnull Collection<PermissionEntry> pathEntries) {
        this.entries.put(path, pathEntries);
    }

    void rememberNotAccessControlled(@Nonnull String path) {
        this.emptyPaths.put(path, null);
    }
}

