/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionProviderImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStore;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStoreImpl;
import org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;

public class MountPermissionProvider
extends PermissionProviderImpl {
    private final MountInfoProvider mountInfoProvider;

    @Nonnull
    public static String getPermissionRootName(@Nonnull Mount mount, @Nonnull String workspace) {
        if (mount.isDefault()) {
            return workspace;
        }
        return mount.getPathFragmentName() + "-" + workspace;
    }

    public MountPermissionProvider(@Nonnull Root root, @Nonnull String workspaceName, @Nonnull Set<Principal> principals, @Nonnull RestrictionProvider restrictionProvider, @Nonnull ConfigurationParameters options, @Nonnull Context ctx, @Nonnull MountInfoProvider mountInfoProvider, @Nonnull RootProvider rootProvider) {
        super(root, workspaceName, principals, restrictionProvider, options, ctx, rootProvider);
        this.mountInfoProvider = mountInfoProvider;
    }

    @Override
    protected PermissionStore getPermissionStore(Root root, String workspaceName, RestrictionProvider restrictionProvider) {
        ArrayList stores = Lists.newArrayList();
        stores.add(new PermissionStoreImpl(root, workspaceName, restrictionProvider));
        for (Mount m : this.mountInfoProvider.getNonDefaultMounts()) {
            String psRoot = MountPermissionProvider.getPermissionRootName(m, workspaceName);
            PermissionStoreImpl ps = new PermissionStoreImpl(root, psRoot, restrictionProvider);
            stores.add(ps);
        }
        return new MountPermissionStore(stores);
    }

    private static class MountPermissionStore
    implements PermissionStore {
        private final List<PermissionStoreImpl> stores;

        public MountPermissionStore(List<PermissionStoreImpl> stores) {
            this.stores = stores;
        }

        @Override
        public Collection<PermissionEntry> load(Collection<PermissionEntry> entries, String principalName, String path) {
            for (PermissionStoreImpl store : this.stores) {
                Collection<PermissionEntry> col = store.load(null, principalName, path);
                if (col == null || col.isEmpty()) continue;
                return col;
            }
            return ImmutableSet.of();
        }

        @Override
        public PrincipalPermissionEntries load(String principalName) {
            PrincipalPermissionEntries ppe = new PrincipalPermissionEntries();
            for (PermissionStoreImpl store : this.stores) {
                ppe.getEntries().putAll(store.load(principalName).getEntries());
            }
            ppe.setFullyLoaded(true);
            return ppe;
        }

        @Override
        public long getNumEntries(String principalName, long max) {
            long num = 0L;
            for (PermissionStoreImpl store : this.stores) {
                if ((num += store.getNumEntries(principalName, max)) >= max) break;
            }
            return num;
        }

        @Override
        public void flush(Root root) {
            for (PermissionStoreImpl store : this.stores) {
                store.flush(root);
            }
        }
    }
}

