/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.plugins.tree.impl.ImmutableTree;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;

final class CompositeTreePermission
implements TreePermission {
    private final ImmutableTree tree;
    private final TreeType type;
    private final CompositeAuthorizationConfiguration.CompositionType compositionType;
    private final TreeTypeProvider typeProvider;
    private final AggregatedPermissionProvider[] providers;
    private final TreePermission[] treePermissions;
    private final int childSize;
    private Boolean canRead;
    private Boolean canReadProperties;

    private CompositeTreePermission(@Nonnull ImmutableTree tree, @Nonnull TreeType type, @Nonnull TreeTypeProvider typeProvider, @Nonnull AggregatedPermissionProvider[] providers, @Nonnull TreePermission[] treePermissions, int cnt, @Nonnull CompositeAuthorizationConfiguration.CompositionType compositionType) {
        this.tree = tree;
        this.type = type;
        this.typeProvider = typeProvider;
        this.providers = providers;
        this.treePermissions = treePermissions;
        this.childSize = providers.length - cnt;
        this.compositionType = compositionType;
    }

    static TreePermission create(@Nonnull ImmutableTree rootTree, @Nonnull TreeTypeProvider typeProvider, @Nonnull AggregatedPermissionProvider[] providers, @Nonnull CompositeAuthorizationConfiguration.CompositionType compositionType) {
        switch (providers.length) {
            case 0: {
                return TreePermission.EMPTY;
            }
            case 1: {
                return providers[0].getTreePermission(rootTree, TreeType.DEFAULT, TreePermission.EMPTY);
            }
        }
        int cnt = 0;
        TreePermission[] treePermissions = new TreePermission[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            TreePermission tp = providers[i].getTreePermission(rootTree, TreeType.DEFAULT, TreePermission.EMPTY);
            if (!CompositeTreePermission.isValid(tp)) {
                ++cnt;
            }
            treePermissions[i] = tp;
        }
        return new CompositeTreePermission(rootTree, TreeType.DEFAULT, typeProvider, providers, treePermissions, cnt, compositionType);
    }

    static TreePermission create(@Nonnull ImmutableTree tree, @Nonnull CompositeTreePermission parentPermission) {
        return CompositeTreePermission.create(() -> tree, tree.getName(), tree.getNodeState(), parentPermission, null);
    }

    static TreePermission create(@Nonnull ImmutableTree tree, @Nonnull CompositeTreePermission parentPermission, @Nullable TreeType treeType) {
        return CompositeTreePermission.create(() -> tree, tree.getName(), tree.getNodeState(), parentPermission, treeType);
    }

    private static TreePermission create(@Nonnull Supplier<ImmutableTree> lazyTree, @Nonnull String childName, @Nonnull NodeState childState, @Nonnull CompositeTreePermission parentPermission, @Nullable TreeType treeType) {
        switch (parentPermission.childSize) {
            case 0: {
                return TreePermission.EMPTY;
            }
            case 1: {
                TreePermission parent = null;
                for (TreePermission tp : parentPermission.treePermissions) {
                    if (!CompositeTreePermission.isValid(tp)) continue;
                    parent = tp;
                    break;
                }
                return parent == null ? TreePermission.EMPTY : parent.getChildPermission(childName, childState);
            }
        }
        ImmutableTree tree = lazyTree.get();
        TreeType type = treeType != null ? treeType : CompositeTreePermission.getType(tree, parentPermission);
        AggregatedPermissionProvider[] pvds = new AggregatedPermissionProvider[parentPermission.childSize];
        TreePermission[] tps = new TreePermission[parentPermission.childSize];
        int cnt = 0;
        int j = 0;
        for (int i = 0; i < parentPermission.providers.length; ++i) {
            TreePermission parent = parentPermission.treePermissions[i];
            if (!CompositeTreePermission.isValid(parent)) continue;
            AggregatedPermissionProvider provider = parentPermission.providers[i];
            TreePermission tp = provider.getTreePermission(tree, type, parent);
            if (!CompositeTreePermission.isValid(tp)) {
                ++cnt;
            }
            tps[j] = tp;
            pvds[j] = provider;
            ++j;
        }
        return new CompositeTreePermission(tree, type, parentPermission.typeProvider, pvds, tps, cnt, parentPermission.compositionType);
    }

    @Override
    @Nonnull
    public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
        return CompositeTreePermission.create(() -> new ImmutableTree(this.tree, childName, childState), childName, childState, this, null);
    }

    @Override
    public boolean canRead() {
        if (this.canRead == null) {
            this.canRead = this.grantsRead(null);
        }
        return this.canRead;
    }

    @Override
    public boolean canRead(@Nonnull PropertyState property) {
        return this.grantsRead(property);
    }

    @Override
    public boolean canReadAll() {
        return false;
    }

    @Override
    public boolean canReadProperties() {
        if (this.canReadProperties == null) {
            TreePermission tp;
            long supported;
            boolean readable = false;
            for (int i = 0; !(i >= this.providers.length || CompositeTreePermission.doEvaluate(supported = this.providers[i].supportedPermissions(tp = this.treePermissions[i], null, 2L)) && (!(readable = tp.canReadProperties()) && this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND || readable && this.compositionType == CompositeAuthorizationConfiguration.CompositionType.OR)); ++i) {
            }
            this.canReadProperties = readable;
        }
        return this.canReadProperties;
    }

    @Override
    public boolean isGranted(long permissions) {
        return this.grantsPermission(permissions, null);
    }

    @Override
    public boolean isGranted(long permissions, @Nonnull PropertyState property) {
        return this.grantsPermission(permissions, property);
    }

    private boolean grantsPermission(long permissions, @Nullable PropertyState property) {
        boolean isGranted = false;
        long coveredPermissions = 0L;
        for (int i = 0; i < this.providers.length; ++i) {
            TreePermission tp = this.treePermissions[i];
            long supported = this.providers[i].supportedPermissions(tp, property, permissions);
            if (!CompositeTreePermission.doEvaluate(supported)) continue;
            if (this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
                boolean bl = isGranted = property == null ? tp.isGranted(supported) : tp.isGranted(supported, property);
                if (!isGranted) {
                    return false;
                }
                coveredPermissions |= supported;
                continue;
            }
            for (long p : Permissions.aggregates(permissions)) {
                boolean aGrant = property == null ? tp.isGranted(p) : tp.isGranted(p, property);
                if (!aGrant) continue;
                coveredPermissions |= p;
                isGranted = true;
            }
        }
        return isGranted && coveredPermissions == permissions;
    }

    private boolean grantsRead(@Nullable PropertyState property) {
        if (property != null && this.canReadProperties()) {
            return true;
        }
        boolean readable = false;
        for (int i = 0; i < this.providers.length; ++i) {
            TreePermission tp = this.treePermissions[i];
            long supported = this.providers[i].supportedPermissions(tp, property, property == null ? 1L : 2L);
            if (!CompositeTreePermission.doEvaluate(supported)) continue;
            boolean bl = readable = property == null ? tp.canRead() : tp.canRead(property);
            if (!readable && this.compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
                return false;
            }
            if (!readable || this.compositionType != CompositeAuthorizationConfiguration.CompositionType.OR) continue;
            return true;
        }
        return readable;
    }

    private static boolean doEvaluate(long supportedPermissions) {
        return supportedPermissions != 0L;
    }

    private static boolean isValid(@Nonnull TreePermission tp) {
        return NO_RECOURSE != tp;
    }

    private static TreeType getType(@Nonnull Tree tree, @Nonnull CompositeTreePermission parent) {
        return parent.typeProvider.getType(tree, parent.type);
    }
}

