/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.ACL;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;

final class Util
implements AccessControlConstants {
    private Util() {
    }

    public static void checkValidPrincipal(@Nullable Principal principal, @Nonnull PrincipalManager principalManager) throws AccessControlException {
        Util.checkValidPrincipal(principal, principalManager, 3);
    }

    public static boolean checkValidPrincipal(@Nullable Principal principal, @Nonnull PrincipalManager principalManager, int importBehavior) throws AccessControlException {
        String name;
        String string = name = principal == null ? null : principal.getName();
        if (name == null || name.isEmpty()) {
            throw new AccessControlException("Invalid principal " + name);
        }
        if (!(principal instanceof PrincipalImpl) && !principalManager.hasPrincipal(name)) {
            switch (importBehavior) {
                case 3: {
                    throw new AccessControlException("Unknown principal " + name);
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
            }
            throw new IllegalArgumentException("Invalid import behavior " + importBehavior);
        }
        return true;
    }

    public static void checkValidPrincipals(@Nullable Set<Principal> principals, @Nonnull PrincipalManager principalManager) throws AccessControlException {
        if (principals == null) {
            throw new AccessControlException("Valid principals expected. Found null.");
        }
        for (Principal principal : principals) {
            Util.checkValidPrincipal(principal, principalManager);
        }
    }

    public static boolean isValidPolicy(@Nullable String oakPath, @Nonnull AccessControlPolicy policy) {
        if (policy instanceof ACL) {
            String path = ((ACL)policy).getOakPath();
            return !(path == null && oakPath != null || path != null && !path.equals(oakPath));
        }
        return false;
    }

    public static void checkValidPolicy(@Nullable String oakPath, @Nonnull AccessControlPolicy policy) throws AccessControlException {
        if (!Util.isValidPolicy(oakPath, policy)) {
            throw new AccessControlException("Invalid access control policy " + policy);
        }
    }

    public static boolean isAccessControlled(@Nullable String oakPath, @Nonnull Tree tree, @Nonnull ReadOnlyNodeTypeManager ntMgr) {
        String mixinName = Util.getMixinName(oakPath);
        return ntMgr.isNodeType(tree, mixinName);
    }

    public static boolean isACE(@Nonnull Tree tree, @Nonnull ReadOnlyNodeTypeManager ntMgr) {
        return tree.exists() && ntMgr.isNodeType(tree, "rep:ACE");
    }

    @Nonnull
    public static String getMixinName(@Nullable String oakPath) {
        return oakPath == null ? "rep:RepoAccessControllable" : "rep:AccessControllable";
    }

    @Nonnull
    public static String getAclName(@Nullable String oakPath) {
        return oakPath == null ? "rep:repoPolicy" : "rep:policy";
    }

    @Nonnull
    public static String generateAceName(@Nonnull ACE ace, int index) {
        String hint;
        String string = hint = ace.isAllow() ? "allow" : "deny";
        if (index == 0) {
            return hint;
        }
        return hint + index;
    }

    public static int getImportBehavior(AuthorizationConfiguration config) {
        String importBehaviorStr = config.getParameters().getConfigValue("importBehavior", "abort");
        return ImportBehavior.valueFromString(importBehaviorStr);
    }
}

