/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value.jcr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.namepath.JcrPathParser;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.plugins.value.ErrorValue;
import org.apache.jackrabbit.oak.plugins.value.jcr.BinaryImpl;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.LoggerFactory;

public class ValueFactoryImpl
implements ValueFactory {
    private static final PerfLogger binOpsLogger = new PerfLogger(LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations.binary.perf"));
    private final Root root;
    private final NamePathMapper namePathMapper;

    public ValueFactoryImpl(@Nonnull Root root, @Nonnull NamePathMapper namePathMapper) {
        this.root = (Root)Preconditions.checkNotNull((Object)root);
        this.namePathMapper = (NamePathMapper)Preconditions.checkNotNull((Object)namePathMapper);
    }

    public static Value createValue(PropertyState property, NamePathMapper namePathMapper) {
        return ValueImpl.newValue(property, namePathMapper);
    }

    @Nonnull
    public static Value createValue(@Nonnull PropertyValue property, @Nonnull NamePathMapper namePathMapper) {
        PropertyState ps = PropertyValues.create(property);
        if (ps == null) {
            throw new IllegalArgumentException("Failed to convert the specified property value to a property state.");
        }
        return ValueImpl.newValue(ps, namePathMapper);
    }

    public static List<Value> createValues(PropertyState property, NamePathMapper namePathMapper) {
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < property.count(); ++i) {
            values.add(ValueImpl.newValue(property, i, namePathMapper));
        }
        return values;
    }

    public List<Value> createValues(PropertyState property) {
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < property.count(); ++i) {
            values.add(ValueImpl.newValue(property, i, this.namePathMapper));
        }
        return values;
    }

    public Value createValue(String value) {
        return ValueImpl.newValue(StringPropertyState.stringProperty("", value), this.namePathMapper);
    }

    public Value createValue(InputStream value) {
        try {
            return this.createBinaryValue(value);
        }
        catch (IOException e) {
            return new ErrorValue(e, 2);
        }
        catch (RepositoryException e) {
            return new ErrorValue((Exception)((Object)e), 2);
        }
    }

    public Value createValue(Binary value) {
        try {
            String reference;
            Blob blob;
            if (value instanceof BinaryImpl) {
                return ((BinaryImpl)value).getBinaryValue();
            }
            if (value instanceof ReferenceBinary && (blob = this.root.getBlob(reference = ((ReferenceBinary)value).getReference())) != null) {
                return this.createBinaryValue(blob);
            }
            return this.createBinaryValue(value.getStream());
        }
        catch (RepositoryException e) {
            return new ErrorValue((Exception)((Object)e), 2);
        }
        catch (IOException e) {
            return new ErrorValue(e, 2);
        }
    }

    public Value createValue(long value) {
        return ValueImpl.newValue(LongPropertyState.createLongProperty("", value), this.namePathMapper);
    }

    public Value createValue(double value) {
        return ValueImpl.newValue(DoublePropertyState.doubleProperty("", value), this.namePathMapper);
    }

    public Value createValue(Calendar value) {
        return ValueImpl.newValue(PropertyStates.createProperty("", value), this.namePathMapper);
    }

    public Value createValue(boolean value) {
        return ValueImpl.newValue(BooleanPropertyState.booleanProperty("", value), this.namePathMapper);
    }

    public Value createValue(Node value) throws RepositoryException {
        return this.createValue(value, false);
    }

    public Value createValue(Node value, boolean weak) throws RepositoryException {
        if (!value.isNodeType("{http://www.jcp.org/jcr/mix/1.0}referenceable")) {
            throw new ValueFormatException("Node is not referenceable: " + value.getPath());
        }
        return weak ? ValueImpl.newValue(GenericPropertyState.weakreferenceProperty("", value.getUUID()), this.namePathMapper) : ValueImpl.newValue(GenericPropertyState.referenceProperty("", value.getUUID()), this.namePathMapper);
    }

    public Value createValue(BigDecimal value) {
        return ValueImpl.newValue(DecimalPropertyState.decimalProperty("", value), this.namePathMapper);
    }

    public Value createValue(String value, int type) throws ValueFormatException {
        if (value == null) {
            throw new ValueFormatException("null");
        }
        try {
            switch (type) {
                case 1: {
                    return this.createValue(value);
                }
                case 2: {
                    return ValueImpl.newValue(BinaryPropertyState.binaryProperty("", value), this.namePathMapper);
                }
                case 3: {
                    return this.createValue(Conversions.convert(value).toLong());
                }
                case 4: {
                    return this.createValue(Conversions.convert(value).toDouble());
                }
                case 5: {
                    if (ISO8601.parse(value) == null) {
                        throw new ValueFormatException("Invalid date " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.dateProperty("", value), this.namePathMapper);
                }
                case 6: {
                    return this.createValue(Conversions.convert(value).toBoolean());
                }
                case 7: {
                    String oakName = this.namePathMapper.getOakNameOrNull(value);
                    if (oakName == null || !JcrNameParser.validate(oakName)) {
                        throw new ValueFormatException("Invalid name: " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.nameProperty("", oakName), this.namePathMapper);
                }
                case 8: {
                    String oakValue = value;
                    if (!(value.startsWith("[") && value.endsWith("]") || (oakValue = this.namePathMapper.getOakPath(value)) != null && JcrPathParser.validate(oakValue))) {
                        throw new ValueFormatException("Invalid path: " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.pathProperty("", oakValue), this.namePathMapper);
                }
                case 9: {
                    if (!UUIDUtils.isValidUUID(value)) {
                        throw new ValueFormatException("Invalid reference value " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.referenceProperty("", value), this.namePathMapper);
                }
                case 10: {
                    if (!UUIDUtils.isValidUUID(value)) {
                        throw new ValueFormatException("Invalid weak reference value " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.weakreferenceProperty("", value), this.namePathMapper);
                }
                case 11: {
                    new URI(value);
                    return ValueImpl.newValue(GenericPropertyState.uriProperty("", value), this.namePathMapper);
                }
                case 12: {
                    return this.createValue(Conversions.convert(value).toDecimal());
                }
            }
            throw new ValueFormatException("Invalid type: " + type);
        }
        catch (NumberFormatException | URISyntaxException e) {
            throw new ValueFormatException("Invalid value " + value + " for type " + PropertyType.nameFromValue((int)type), (Throwable)e);
        }
    }

    public Binary createBinary(InputStream stream) throws RepositoryException {
        try {
            return new BinaryImpl(this.createBinaryValue(stream));
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private ValueImpl createBinaryValue(InputStream value) throws IOException, RepositoryException {
        long start = binOpsLogger.start();
        Blob blob = this.root.createBlob(value);
        binOpsLogger.end(start, -1L, "Created binary property of size [{}]", (Object)blob.length());
        return this.createBinaryValue(blob);
    }

    private ValueImpl createBinaryValue(Blob blob) throws RepositoryException {
        return new ValueImpl(BinaryPropertyState.binaryProperty("", blob), this.namePathMapper);
    }
}

