/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.SinglePropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;

public class StringPropertyState
extends SinglePropertyState<String> {
    private final String value;

    public StringPropertyState(@Nonnull String name, @Nonnull String value) {
        super(name);
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public static PropertyState stringProperty(@Nonnull String name, @Nonnull String value) {
        return new StringPropertyState(name, value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Conversions.Converter getConverter() {
        return Conversions.convert(this.value);
    }

    @Override
    public Type<?> getType() {
        return Type.STRING;
    }
}

