/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDisabler {
    private static final Logger log = LoggerFactory.getLogger(IndexDisabler.class);
    private final NodeBuilder rootBuilder;

    public IndexDisabler(NodeBuilder rootBuilder) {
        this.rootBuilder = rootBuilder;
    }

    public boolean markDisableFlagIfRequired(String currentIndexPath, NodeBuilder idxBuilder) {
        boolean disableRequired = this.isAnyIndexToBeDisabled(currentIndexPath, idxBuilder);
        if (disableRequired) {
            idxBuilder.setProperty(":disableIndexesOnNextCycle", true);
        }
        return disableRequired;
    }

    private boolean isAnyIndexToBeDisabled(String currentIndexPath, NodeBuilder idxBuilder) {
        PropertyState indexPathsProp = idxBuilder.getProperty("supersedes");
        if (indexPathsProp == null) {
            return false;
        }
        Iterable<String> indexPaths = indexPathsProp.getValue(Type.STRINGS);
        for (String indexPath : indexPaths) {
            if (IndexDisabler.isNodeTypePath(indexPath)) {
                String nodeTypeName = PathUtils.getName(indexPath).substring(1);
                String nodeTypeIndexPath = PathUtils.getParentPath(indexPath);
                NodeState idxSate = NodeStateUtils.getNode(this.rootBuilder.getBaseState(), nodeTypeIndexPath);
                PropertyState declaredNodeTypes = idxSate.getProperty("declaringNodeTypes");
                if (!idxSate.exists() || declaredNodeTypes == null || !Iterables.contains(declaredNodeTypes.getValue(Type.NAMES), (Object)nodeTypeName)) continue;
                return true;
            }
            NodeState idxSate = NodeStateUtils.getNode(this.rootBuilder.getBaseState(), indexPath);
            if (!idxSate.exists() || "disabled".equals(idxSate.getString("type"))) continue;
            return true;
        }
        return false;
    }

    public List<String> disableOldIndexes(String currentIndexPath, NodeBuilder idxBuilder) {
        PropertyState indexPathsProp = idxBuilder.getProperty("supersedes");
        if (indexPathsProp == null) {
            return Collections.emptyList();
        }
        if (!idxBuilder.getBoolean(":disableIndexesOnNextCycle")) {
            return Collections.emptyList();
        }
        if (!idxBuilder.getBaseState().getBoolean(":disableIndexesOnNextCycle")) {
            return Collections.emptyList();
        }
        Iterable<String> indexPaths = indexPathsProp.getValue(Type.STRINGS);
        ArrayList<String> disabledIndexes = new ArrayList<String>();
        for (String indexPath : indexPaths) {
            if (IndexDisabler.isNodeTypePath(indexPath)) {
                HashSet existingTypes;
                String nodeTypeName = PathUtils.getName(indexPath).substring(1);
                String nodeTypeIndexPath = PathUtils.getParentPath(indexPath);
                NodeBuilder nodeTypeIndexBuilder = IndexDisabler.child(this.rootBuilder, nodeTypeIndexPath);
                PropertyState declaringNodeTypes = nodeTypeIndexBuilder.getProperty("declaringNodeTypes");
                if (!nodeTypeIndexBuilder.exists() || declaringNodeTypes == null || !(existingTypes = Sets.newHashSet(declaringNodeTypes.getValue(Type.NAMES))).remove(nodeTypeName)) continue;
                disabledIndexes.add(indexPath);
                nodeTypeIndexBuilder.setProperty("declaringNodeTypes", existingTypes, Type.NAMES);
                continue;
            }
            NodeBuilder disabledIndexBuilder = IndexDisabler.child(this.rootBuilder, indexPath);
            if (!disabledIndexBuilder.exists()) continue;
            disabledIndexBuilder.setProperty("type", "disabled");
            disabledIndexes.add(indexPath);
        }
        if (!disabledIndexes.isEmpty()) {
            log.info("Index at [{}] supersedes indexes {}. Marking those as disabled", (Object)currentIndexPath, disabledIndexes);
            idxBuilder.removeProperty(":disableIndexesOnNextCycle");
        }
        return disabledIndexes;
    }

    private static boolean isNodeTypePath(String indexPath) {
        String lastPathSegment = PathUtils.getName(indexPath);
        return lastPathSegment.startsWith("@");
    }

    private static NodeBuilder child(NodeBuilder nb, String path) {
        for (String name : PathUtils.elements((String)Preconditions.checkNotNull((Object)path))) {
            nb = nb.getChildNode(name);
        }
        return nb;
    }
}

