/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.nodetype;

import com.google.common.collect.Iterables;
import org.apache.jackrabbit.JcrConstants;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexLookup;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class NodeTypeIndexLookup
implements JcrConstants {
    static final double MINIMUM_COST = 2.05;
    private final NodeState root;
    private final MountInfoProvider mountInfoProvider;

    public NodeTypeIndexLookup(NodeState root, MountInfoProvider mountInfoProvider) {
        this.root = root;
        this.mountInfoProvider = mountInfoProvider;
    }

    public boolean isIndexed(String path, Filter f) {
        int slash;
        PropertyIndexLookup lookup = new PropertyIndexLookup(this.root, this.mountInfoProvider);
        if (lookup.isIndexed("jcr:primaryType", path, f) && lookup.isIndexed("jcr:mixinTypes", path, f)) {
            return true;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((slash = path.indexOf(47)) == -1) {
            return false;
        }
        NodeState child = this.root.getChildNode(path.substring(0, slash));
        return new NodeTypeIndexLookup(child, this.mountInfoProvider).isIndexed(path.substring(slash), f);
    }

    public double getCost(Filter filter) {
        PropertyIndexLookup lookup = new PropertyIndexLookup(this.root, this.mountInfoProvider);
        return lookup.getCost(filter, "jcr:primaryType", PropertyValues.newName(filter.getPrimaryTypes())) + lookup.getCost(filter, "jcr:mixinTypes", PropertyValues.newName(filter.getMixinTypes()));
    }

    public Iterable<String> query(Filter filter) {
        PropertyIndexLookup lookup = new PropertyIndexLookup(this.root, this.mountInfoProvider);
        return Iterables.concat(lookup.query(filter, "jcr:primaryType", PropertyValues.newName(filter.getPrimaryTypes())), lookup.query(filter, "jcr:mixinTypes", PropertyValues.newName(filter.getMixinTypes())));
    }
}

