/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class IndexUtils {
    private IndexUtils() {
    }

    public static NodeBuilder getOrCreateOakIndex(NodeBuilder root) {
        NodeBuilder index;
        if (!root.hasChildNode("oak:index")) {
            index = root.child("oak:index");
            index.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
        } else {
            index = root.child("oak:index");
        }
        return index;
    }

    public static NodeBuilder createIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String indexDefName, boolean reindex, boolean unique, @Nonnull Collection<String> propertyNames, @Nullable Collection<String> declaringNodeTypeNames) {
        NodeBuilder entry = index.child(indexDefName).setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "property").setProperty("reindex", reindex);
        if (unique) {
            entry.setProperty("unique", unique);
        }
        entry.setProperty(PropertyStates.createProperty("propertyNames", propertyNames, Type.NAMES));
        if (declaringNodeTypeNames != null && !declaringNodeTypeNames.isEmpty()) {
            entry.setProperty(PropertyStates.createProperty("declaringNodeTypes", declaringNodeTypeNames, Type.NAMES));
        }
        return entry;
    }

    public static Tree createIndexDefinition(@Nonnull Tree indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull String[] propertyNames, String ... declaringNodeTypeNames) throws RepositoryException {
        return IndexUtils.createIndexDefinition(indexNode, indexDefName, unique, (Collection<String>)ImmutableList.copyOf((Object[])propertyNames), (Collection<String>)ImmutableList.copyOf((Object[])declaringNodeTypeNames), "property", null);
    }

    public static Tree createIndexDefinition(@Nonnull Tree indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull Collection<String> propertyNames, @CheckForNull Collection<String> declaringNodeTypeNames, @Nonnull String propertyIndexType, @CheckForNull Map<String, String> properties) throws RepositoryException {
        Tree entry = TreeUtil.getOrAddChild(indexNode, indexDefName, "oak:QueryIndexDefinition");
        entry.setProperty("type", propertyIndexType);
        entry.setProperty("reindex", true);
        if (unique) {
            entry.setProperty("unique", true);
        }
        if (declaringNodeTypeNames != null && declaringNodeTypeNames.size() > 0) {
            entry.setProperty("declaringNodeTypes", declaringNodeTypeNames, Type.NAMES);
        }
        entry.setProperty("propertyNames", propertyNames, Type.NAMES);
        if (properties != null) {
            for (String k : properties.keySet()) {
                entry.setProperty(k, properties.get(k));
            }
        }
        return entry;
    }

    public static void createReferenceIndex(@Nonnull NodeBuilder index) {
        index.child("reference").setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "reference").setProperty("info", "Oak index for reference lookup.");
    }

    public static boolean isIndexNodeType(NodeState state) {
        PropertyState ps = state.getProperty("jcr:primaryType");
        return ps != null && ps.getValue(Type.STRING).equals("oak:QueryIndexDefinition");
    }

    public static boolean isIndexNodeType(NodeState state, String typeIn) {
        if (!IndexUtils.isIndexNodeType(state)) {
            return false;
        }
        PropertyState type = state.getProperty("type");
        return type != null && !type.isArray() && type.getValue(Type.STRING).equals(typeIn);
    }

    public static NodeBuilder createIndexDefinition(@Nonnull NodeBuilder indexNode, @Nonnull String indexDefName, boolean unique, @Nonnull Iterable<String> propertyNames, @Nullable String[] declaringNodeTypeNames, @Nonnull String propertyIndexType, Map<String, String> properties) throws RepositoryException {
        NodeBuilder entry = indexNode.child(indexDefName).setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", propertyIndexType).setProperty("reindex", false);
        if (unique) {
            entry.setProperty("unique", unique);
        }
        entry.setProperty(PropertyStates.createProperty("propertyNames", propertyNames, Type.NAMES));
        if (declaringNodeTypeNames != null && declaringNodeTypeNames.length > 0) {
            entry.setProperty(PropertyStates.createProperty("declaringNodeTypes", declaringNodeTypeNames, Type.NAMES));
        }
        if (properties != null) {
            for (String k : properties.keySet()) {
                entry.setProperty(k, properties.get(k));
            }
        }
        return entry;
    }

    @CheckForNull
    public static String getAsyncLaneName(NodeState idxState, String indexPath) {
        return IndexUtils.getAsyncLaneName(idxState, indexPath, idxState.getProperty("async"));
    }

    @CheckForNull
    public static String getAsyncLaneName(NodeState idxState, String indexPath, PropertyState async) {
        if (async != null) {
            HashSet asyncNames = Sets.newHashSet(async.getValue(Type.STRINGS));
            asyncNames.remove("nrt");
            asyncNames.remove("sync");
            Preconditions.checkArgument((!asyncNames.isEmpty() ? 1 : 0) != 0, (String)"No valid async name found for index [%s], definition %s", (Object[])new Object[]{indexPath, idxState});
            return (String)Iterables.getOnlyElement((Iterable)asyncNames);
        }
        return null;
    }
}

