/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.Calendar;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.commit.DefaultThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.ISO8601;

public class JcrLastModifiedConflictHandler
extends DefaultThreeWayConflictHandler {
    public JcrLastModifiedConflictHandler() {
        super(ThreeWayConflictHandler.Resolution.IGNORED);
    }

    @Override
    @Nonnull
    public ThreeWayConflictHandler.Resolution addExistingProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        if (JcrLastModifiedConflictHandler.isModifiedOrCreated(ours.getName())) {
            JcrLastModifiedConflictHandler.merge(parent, ours, theirs);
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @Nonnull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(NodeBuilder parent, PropertyState ours, PropertyState theirs, PropertyState base) {
        if (JcrLastModifiedConflictHandler.isModifiedOrCreated(ours.getName())) {
            JcrLastModifiedConflictHandler.merge(parent, ours, theirs);
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static void merge(NodeBuilder parent, PropertyState ours, PropertyState theirs) {
        Calendar o = ISO8601.parse(ours.getValue(Type.DATE));
        Calendar t = ISO8601.parse(theirs.getValue(Type.DATE));
        if ("jcr:created".equals(ours.getName())) {
            parent.setProperty(ours.getName(), JcrLastModifiedConflictHandler.pick(o, t, true));
        } else {
            parent.setProperty(ours.getName(), JcrLastModifiedConflictHandler.pick(o, t, false));
        }
    }

    private static Calendar pick(Calendar a, Calendar b, boolean jcrCreated) {
        if (a.before(b)) {
            return jcrCreated ? a : b;
        }
        return jcrCreated ? b : a;
    }

    private static boolean isModifiedOrCreated(String name) {
        return "jcr:lastModified".equals(name) || "jcr:created".equals(name);
    }
}

