/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.osgi;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.ComponentContext;

public class OsgiUtil {
    private OsgiUtil() {
    }

    public static String lookup(ComponentContext context, String name) {
        return OsgiUtil.asString(((ComponentContext)Preconditions.checkNotNull((Object)context)).getProperties().get(Preconditions.checkNotNull((Object)name)));
    }

    public static String lookup(BundleContext context, String name) {
        return OsgiUtil.asString(((BundleContext)Preconditions.checkNotNull((Object)context)).getProperty((String)Preconditions.checkNotNull((Object)name)));
    }

    public static String lookupConfigurationThenFramework(ComponentContext context, String name) {
        return OsgiUtil.lookupConfigurationThenFramework(context, name, name);
    }

    public static String lookupConfigurationThenFramework(ComponentContext context, String nameInComponent, String nameInFramework) {
        String fromComponent = OsgiUtil.lookup(context, nameInComponent);
        if (fromComponent != null) {
            return fromComponent;
        }
        String fromFramework = OsgiUtil.lookup(context.getBundleContext(), nameInFramework);
        if (fromFramework != null) {
            return fromFramework;
        }
        return null;
    }

    public static String lookupFrameworkThenConfiguration(ComponentContext context, String name) {
        return OsgiUtil.lookupFrameworkThenConfiguration(context, name, name);
    }

    public static String lookupFrameworkThenConfiguration(ComponentContext context, String nameInComponent, String nameInFramework) {
        String fromFramework = OsgiUtil.lookup(((ComponentContext)Preconditions.checkNotNull((Object)context)).getBundleContext(), nameInFramework);
        if (fromFramework != null) {
            return fromFramework;
        }
        String fromComponent = OsgiUtil.lookup(context, nameInComponent);
        if (fromComponent != null) {
            return fromComponent;
        }
        return null;
    }

    private static String asString(Object value) {
        if (value == null) {
            return null;
        }
        String string = value.toString().trim();
        if (string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static Filter getFilter(Class<?> clazz, Map<String, String> attributes) {
        StringBuilder filterBuilder = new StringBuilder("(&");
        OsgiUtil.appendLdapFilterAttribute(filterBuilder, "objectClass", clazz.getName());
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            OsgiUtil.appendLdapFilterAttribute(filterBuilder, e.getKey(), e.getValue());
        }
        filterBuilder.append(')');
        try {
            return FrameworkUtil.createFilter((String)filterBuilder.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static StringBuilder appendLdapFilterAttribute(StringBuilder filterBuilder, String key, String value) {
        if (value == null) {
            filterBuilder.append("(!(").append(key).append("=*))");
        } else {
            filterBuilder.append("(").append(key).append("=");
            OsgiUtil.appendEscapedLdapValue(filterBuilder, value);
            filterBuilder.append(")");
        }
        return filterBuilder;
    }

    static StringBuilder appendEscapedLdapValue(StringBuilder filterBuilder, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\' || c == '(' || c == ')' || c == '*') {
                filterBuilder.append('\\');
            }
            filterBuilder.append(c);
        }
        return filterBuilder;
    }
}

