/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

public class PrivilegeManagerDelegator
implements PrivilegeManager {
    private final PrivilegeManager pm;
    private final SessionDelegate delegate;

    public PrivilegeManagerDelegator(SessionDelegate delegate, PrivilegeManager pm) {
        this.pm = pm;
        this.delegate = delegate;
    }

    @Override
    public Privilege[] getRegisteredPrivileges() throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege[]>("getRegisteredPrivileges"){

            @Override
            @Nonnull
            public Privilege[] perform() throws RepositoryException {
                return PrivilegeManagerDelegator.this.pm.getRegisteredPrivileges();
            }
        });
    }

    @Override
    public Privilege getPrivilege(final String privilegeName) throws AccessControlException, RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege>("getPrivilege"){

            @Override
            @Nonnull
            public Privilege perform() throws RepositoryException {
                return PrivilegeManagerDelegator.this.pm.getPrivilege(privilegeName);
            }
        });
    }

    @Override
    public Privilege registerPrivilege(final String privilegeName, final boolean isAbstract, final String[] declaredAggregateNames) throws AccessDeniedException, NamespaceException, RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege>("registerPrivilege", true){

            @Override
            @Nonnull
            public Privilege perform() throws RepositoryException {
                return PrivilegeManagerDelegator.this.pm.registerPrivilege(privilegeName, isAbstract, declaredAggregateNames);
            }
        });
    }
}

