/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import com.google.common.base.Preconditions;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;

final class ImpersonationDelegator
implements Impersonation {
    private final SessionDelegate sessionDelegate;
    private final Impersonation impersonationDelegate;

    private ImpersonationDelegator(SessionDelegate sessionDelegate, Impersonation impersonationDelegate) {
        Preconditions.checkArgument((!(impersonationDelegate instanceof ImpersonationDelegator) ? 1 : 0) != 0);
        this.sessionDelegate = sessionDelegate;
        this.impersonationDelegate = impersonationDelegate;
    }

    static Impersonation wrap(SessionDelegate sessionDelegate, Impersonation impersonation) {
        if (impersonation == null) {
            return null;
        }
        return new ImpersonationDelegator(sessionDelegate, impersonation);
    }

    @Override
    public PrincipalIterator getImpersonators() throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<PrincipalIterator>("getImpersonators"){

            @Override
            @Nonnull
            public PrincipalIterator perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.getImpersonators();
            }
        });
    }

    @Override
    public boolean grantImpersonation(final Principal principal) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("grantImpersonation", true){

            @Override
            @Nonnull
            public Boolean perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.grantImpersonation(principal);
            }
        });
    }

    @Override
    public boolean revokeImpersonation(final Principal principal) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("revokeImpersonation", true){

            @Override
            @Nonnull
            public Boolean perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.revokeImpersonation(principal);
            }
        });
    }

    @Override
    public boolean allows(final Subject subject) throws RepositoryException {
        return this.sessionDelegate.perform(new SessionOperation<Boolean>("allows"){

            @Override
            @Nonnull
            public Boolean perform() throws RepositoryException {
                return ImpersonationDelegator.this.impersonationDelegate.allows(subject);
            }
        });
    }
}

