/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.impl.EmptyInstanceConfig;
import org.apache.sling.testing.junit.rules.util.Action;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceConfigRule
implements TestRule {
    public static final Logger LOG = LoggerFactory.getLogger(InstanceConfigRule.class);
    private final boolean withRestore;
    private InstanceConfig instanceConfig;
    private List<Action> actions;

    public <T extends InstanceConfig> InstanceConfigRule(T instanceConfig, boolean withRestore) {
        this.instanceConfig = instanceConfig;
        this.withRestore = withRestore;
        this.actions = new ArrayList<Action>();
    }

    public <T extends InstanceConfig> InstanceConfigRule(T instanceConfig) {
        this(instanceConfig, true);
    }

    public InstanceConfigRule() {
        this(new EmptyInstanceConfig(), true);
    }

    public <T extends Action> InstanceConfigRule withAction(T action) {
        this.actions.add(action);
        return this;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LOG.debug("Saving instance config {}", InstanceConfigRule.this.instanceConfig.getClass());
                InstanceConfigRule.this.instanceConfig.save();
                for (Action action : InstanceConfigRule.this.actions) {
                    LOG.debug("Calling action {}", action.getClass());
                    action.call();
                }
                LOG.debug("Running base statement");
                base.evaluate();
                if (InstanceConfigRule.this.withRestore) {
                    LOG.debug("Restoring instance config {}", InstanceConfigRule.this.instanceConfig.getClass());
                    InstanceConfigRule.this.instanceConfig.restore();
                }
            }
        };
    }
}

