/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;
import org.apache.sling.testing.resourceresolver.MockResourceResolverFactoryOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.event.EventAdmin;

public class MockResourceResolverFactory
implements ResourceResolverFactory {
    private static final String ROOT_PRIMARY_TYPE = "rep:root";
    private final Map<String, Map<String, Object>> resources = new LinkedHashMap<String, Map<String, Object>>();
    private final MockResourceResolverFactoryOptions options;
    private ThreadLocal<Stack<ResourceResolver>> resolverStackHolder = new ThreadLocal();

    public MockResourceResolverFactory(@Nullable EventAdmin eventAdmin) {
        this(new MockResourceResolverFactoryOptions().setEventAdmin(eventAdmin));
    }

    public MockResourceResolverFactory() {
        this(new MockResourceResolverFactoryOptions());
    }

    public MockResourceResolverFactory(@NotNull MockResourceResolverFactoryOptions options) {
        this.options = options;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("jcr:primaryType", ROOT_PRIMARY_TYPE);
        this.resources.put("/", props);
    }

    @NotNull
    public ResourceResolver getResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (authenticationInfo != null) {
            attributes.put("user.name", authenticationInfo.get("user.name"));
        }
        MockResourceResolver result = new MockResourceResolver(this.options, this, this.resources, attributes);
        Stack<Object> resolverStack = this.resolverStackHolder.get();
        if (resolverStack == null) {
            resolverStack = new Stack();
            this.resolverStackHolder.set(resolverStack);
        }
        resolverStack.push((Object)result);
        return result;
    }

    @NotNull
    public ResourceResolver getAdministrativeResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return new MockResourceResolver(this.options, this, this.resources);
    }

    @NotNull
    public ResourceResolver getServiceResourceResolver(Map<String, Object> authenticationInfo) throws LoginException {
        return new MockResourceResolver(this.options, this, this.resources);
    }

    public ResourceResolver getThreadResourceResolver() {
        ResourceResolver result = null;
        Stack<ResourceResolver> resolverStack = this.resolverStackHolder.get();
        if (resolverStack != null && !resolverStack.isEmpty()) {
            result = resolverStack.peek();
        }
        return result;
    }

    public void closed(@NotNull ResourceResolver resolver) {
        Stack<ResourceResolver> resolverStack = this.resolverStackHolder.get();
        if (resolverStack != null) {
            resolverStack.remove(resolver);
        }
    }
}

