/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public final class MapUtil {
    private MapUtil() {
    }

    public static <T, U> Dictionary<T, U> toDictionary(Map<T, U> map) {
        if (map == null) {
            return null;
        }
        Hashtable<T, U> hashtable = new Hashtable<T, U>();
        for (Map.Entry<T, U> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            hashtable.put(entry.getKey(), entry.getValue());
        }
        return hashtable;
    }

    public static <T, U> Map<T, U> toMap(Dictionary<T, U> dictionary) {
        if (dictionary == null) {
            return null;
        }
        HashMap<T, U> map = new HashMap<T, U>();
        Enumeration<T> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            T key = keys.nextElement();
            map.put(key, dictionary.get(key));
        }
        return map;
    }

    public static Dictionary<String, Object> toDictionary(Object ... args) {
        return MapUtil.toDictionary(MapUtil.toMap(args));
    }

    public static Map<String, Object> toMap(Object ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        if (args.length == 1) {
            if (args[0] instanceof Map) {
                return (Map)args[0];
            }
            if (args[0] instanceof Dictionary) {
                return MapUtil.toMap((Dictionary)args[0]);
            }
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("args must be an even number of name/values:" + Arrays.asList(args));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            Object key = args[i];
            Object value = args[i + 1];
            if (key == null || value == null) continue;
            result.put(key.toString(), value);
        }
        return result;
    }
}

