/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockBundleContext;
import org.apache.sling.testing.mock.osgi.MockComponentContext;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public final class ComponentContextBuilder {
    private BundleContext bundleContext;
    private Dictionary<String, Object> properties;
    private Bundle usingBundle;

    ComponentContextBuilder() {
    }

    public ComponentContextBuilder bundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        return this;
    }

    public ComponentContextBuilder properties(Dictionary<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public ComponentContextBuilder properties(Map<String, Object> properties) {
        this.properties = MapUtil.toDictionary(properties);
        return this;
    }

    public ComponentContextBuilder properties(Object ... properties) {
        this.properties = MapUtil.toDictionary(properties);
        return this;
    }

    public ComponentContextBuilder usingBundle(Bundle usingBundle) {
        this.usingBundle = usingBundle;
        return this;
    }

    public ComponentContext build() {
        if (this.bundleContext == null) {
            this.bundleContext = MockOsgi.newBundleContext();
        }
        if (this.properties == null) {
            this.properties = new Hashtable<String, Object>();
        }
        return new MockComponentContext((MockBundleContext)this.bundleContext, this.properties, this.usingBundle);
    }
}

