/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.jcr.MockQuery;
import org.apache.sling.testing.mock.jcr.MockQueryManager;
import org.apache.sling.testing.mock.jcr.MockQueryResult;
import org.apache.sling.testing.mock.jcr.MockQueryResultHandler;
import org.apache.sling.testing.mock.jcr.MockRepository;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public final class MockJcr {
    public static final String DEFAULT_WORKSPACE = "mockedWorkspace";
    public static final String DEFAULT_USER_ID = "admin";

    private MockJcr() {
    }

    public static Repository newRepository() {
        return new MockRepository();
    }

    public static Session newSession() {
        return MockJcr.newSession(null, null);
    }

    public static Session newSession(String userId, String workspaceName) {
        try {
            return MockJcr.newRepository().login((Credentials)new SimpleCredentials(StringUtils.defaultString((String)userId, (String)DEFAULT_USER_ID), new char[0]), StringUtils.defaultString((String)workspaceName, (String)DEFAULT_WORKSPACE));
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Creating mocked JCR session failed.", ex);
        }
    }

    public static void setQueryResult(Session session, List<Node> resultList) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), resultList);
    }

    public static void setQueryResult(QueryManager queryManager, final List<Node> resultList) {
        MockJcr.addQueryResultHandler(queryManager, new MockQueryResultHandler(){

            @Override
            public MockQueryResult executeQuery(MockQuery query) {
                return new MockQueryResult(resultList);
            }
        });
    }

    public static void setQueryResult(Session session, String statement, String language, List<Node> resultList) {
        MockJcr.setQueryResult(MockJcr.getQueryManager(session), statement, language, resultList);
    }

    public static void setQueryResult(QueryManager queryManager, final String statement, final String language, final List<Node> resultList) {
        MockJcr.addQueryResultHandler(queryManager, new MockQueryResultHandler(){

            @Override
            public MockQueryResult executeQuery(MockQuery query) {
                if (StringUtils.equals((CharSequence)query.getStatement(), (CharSequence)statement) && StringUtils.equals((CharSequence)query.getLanguage(), (CharSequence)language)) {
                    return new MockQueryResult(resultList);
                }
                return null;
            }
        });
    }

    public static void addQueryResultHandler(Session session, MockQueryResultHandler resultHandler) {
        MockJcr.addQueryResultHandler(MockJcr.getQueryManager(session), resultHandler);
    }

    public static void addQueryResultHandler(QueryManager queryManager, MockQueryResultHandler resultHandler) {
        ((MockQueryManager)queryManager).addResultHandler(resultHandler);
    }

    private static QueryManager getQueryManager(Session session) {
        try {
            return session.getWorkspace().getQueryManager();
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to access query manager.", ex);
        }
    }
}

