/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.servlets.resolver.internal.resource.ServletResource;

public class ScriptResource
extends AbstractResource {
    private AtomicReference<Resource> sharedResource = new AtomicReference();
    private final ResourceResolver sharedResourceResolver;
    private final Supplier<ResourceResolver> perThreadResourceResolver;
    private final String path;

    public ScriptResource(Resource resource, Supplier<ResourceResolver> perThreadScriptResolver, ResourceResolver sharedResourceResolver) {
        this.path = resource.getPath();
        this.sharedResourceResolver = sharedResourceResolver;
        this.perThreadResourceResolver = perThreadScriptResolver;
    }

    private Resource getActiveResource() {
        ResourceResolver perThreadResolver = this.perThreadResourceResolver.get();
        if (perThreadResolver != null && perThreadResolver.isLive()) {
            return perThreadResolver.getResource(this.path);
        }
        Resource resource = this.sharedResource.get();
        if (resource == null) {
            resource = this.sharedResourceResolver.getResource(this.path);
            this.sharedResource.set(resource);
        }
        return resource;
    }

    public String getResourceType() {
        return this.getActiveResource().getResourceType();
    }

    public String getResourceSuperType() {
        return this.getActiveResource().getResourceSuperType();
    }

    public ResourceResolver getResourceResolver() {
        return this.getActiveResource().getResourceResolver();
    }

    public <T> T adaptTo(Class<T> type) {
        SlingScript s;
        if (type == Servlet.class) {
            Servlet s2;
            Resource activeResource = this.getActiveResource();
            while (activeResource instanceof ResourceWrapper) {
                activeResource = ((ResourceWrapper)activeResource).getResource();
            }
            if (!(activeResource instanceof ServletResource) && (s2 = (Servlet)super.adaptTo(type)) != null) {
                return (T)s2;
            }
        } else if (type == SlingScript.class && (s = (SlingScript)super.adaptTo(type)) != null) {
            return (T)s;
        }
        return (T)this.getActiveResource().adaptTo(type);
    }

    public String getPath() {
        return this.path;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.getActiveResource().getResourceMetadata();
    }

    public String getName() {
        return ResourceUtil.getName((String)this.path);
    }

    public Resource getParent() {
        return this.getActiveResource().getParent();
    }

    public Resource getChild(String relPath) {
        return this.getActiveResource().getChild(relPath);
    }

    public Iterator<Resource> listChildren() {
        return this.getActiveResource().listChildren();
    }

    public Iterable<Resource> getChildren() {
        return this.getActiveResource().getChildren();
    }

    public boolean isResourceType(String resourceType) {
        return this.getActiveResource().isResourceType(resourceType);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", type=" + this.getResourceType() + ", superType=" + this.getResourceSuperType() + ", path=" + this.getPath();
    }
}

