/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.AbstractPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperation
extends AbstractPostOperation {
    private final SlingFileUploadHandler uploadHandler = new SlingFileUploadHandler();

    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        RequestPathInfo rpi = request.getRequestPathInfo();
        if (rpi.getSelectors() != null && rpi.getSelectors().length > 0 || rpi.getExtension() != null && rpi.getExtension().length() > 0 || rpi.getSuffix() != null && rpi.getSuffix().length() > 0) {
            response.setStatus(403, "DeleteOperation request cannot include any selectors, extension or suffix");
            return;
        }
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        boolean deleteChunks = this.isDeleteChunkRequest(request);
        Iterator<Resource> res = this.getApplyToResources(request);
        if (res == null) {
            Resource resource = request.getResource();
            this.deleteResource(resource, changes, versioningConfiguration, deleteChunks);
        } else {
            while (res.hasNext()) {
                Resource resource = res.next();
                this.deleteResource(resource, changes, versioningConfiguration, deleteChunks);
            }
        }
    }

    private void deleteResource(Resource resource, List<Modification> changes, VersioningConfiguration versioningConfiguration, boolean deleteChunks) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            if (deleteChunks) {
                this.uploadHandler.deleteChunks(node);
            } else {
                this.checkoutIfNecessary(node.getParent(), changes, versioningConfiguration);
                node.remove();
            }
        } else {
            try {
                resource.getResourceResolver().delete(resource);
            }
            catch (PersistenceException pe) {
                if (pe.getCause() instanceof RepositoryException) {
                    throw (RepositoryException)pe.getCause();
                }
                throw new RepositoryException((Throwable)pe);
            }
        }
        changes.add(Modification.onDeleted(resource.getPath()));
    }

    protected boolean isDeleteChunkRequest(SlingHttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter(":applyToChunks"));
    }
}

