/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.helper;

import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.servlets.post.impl.helper.SlingFileUploadHandler;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Apache Sling Post Chunk Upload : Cleanup Task", description="Task to regularly purge incomplete chunks from the repository")
@Service(value={Runnable.class})
@Properties(value={@Property(name="scheduler.expression", value={"31 41 0/12 * * ?"}, label="Schedule", description="Cron expression scheudling this job. Default is hourly 17m23s after the hour. See http://www.docjar.com/docs/api/org/quartz/CronTrigger.html for a description of the format for this value."), @Property(name="service.description", value={"Periodic Chunk Cleanup Job"}, propertyPrivate=true), @Property(name="service.vendor", value={"The Apache Software Foundation"}, propertyPrivate=true)})
public class ChunkCleanUpTask
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingRepository repository;
    @Property(intValue={360}, description="The chunk's age in minutes before it is considered for clean up.")
    private static final String CHUNK_CLEANUP_AGE = "chunk.cleanup.age";
    private SlingFileUploadHandler uploadhandler = new SlingFileUploadHandler();
    private long chunkCleanUpAge;

    @Override
    public void run() {
        this.log.debug("ChunkCleanUpTask: Starting cleanup");
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long start = System.currentTimeMillis();
        int numCleaned = 0;
        int numLive = 0;
        Session admin = null;
        try {
            admin = this.repository.loginAdministrative(null);
            QueryManager qm = admin.getWorkspace().getQueryManager();
            QueryResult queryres = qm.createQuery("SELECT * FROM [sling:chunks] ", "JCR-SQL2").execute();
            NodeIterator nodeItr = queryres.getNodes();
            while (nodeItr.hasNext()) {
                Node node = nodeItr.nextNode();
                if (this.isEligibleForCleanUp(node)) {
                    ++numCleaned;
                    this.uploadhandler.deleteChunks(node);
                    continue;
                }
                ++numLive;
            }
            if (admin.hasPendingChanges()) {
                try {
                    admin.refresh(true);
                    admin.save();
                }
                catch (InvalidItemStateException iise) {
                    this.log.info("ChunkCleanUpTask: Concurrent modification to one or more of the chunk to be removed. Retrying later");
                }
                catch (RepositoryException re) {
                    this.log.info("ChunkCleanUpTask: Failed persisting chunk removal. Retrying later");
                }
            }
        }
        catch (Throwable t) {
            this.log.error("ChunkCleanUpTask: General failure while trying to cleanup chunks", t);
        }
        finally {
            if (admin != null) {
                admin.logout();
            }
        }
        long end = System.currentTimeMillis();
        this.log.info("ChunkCleanUpTask finished: Removed {} chunk upload(s) in {}ms ({} chunk upload(s) still active)", new Object[]{numCleaned, end - start, numLive});
    }

    private boolean isEligibleForCleanUp(Node node) throws RepositoryException {
        Node lastChunkNode = this.uploadhandler.getLastChunk(node);
        return lastChunkNode != null && System.currentTimeMillis() - lastChunkNode.getProperty("{http://www.jcp.org/jcr/1.0}created").getDate().getTimeInMillis() > this.chunkCleanUpAge;
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> configuration) {
        this.chunkCleanUpAge = OsgiUtil.toInteger((Object)configuration.get(CHUNK_CLEANUP_AGE), (int)1) * 60 * 1000;
        this.log.info("scheduler config [{}], chunkGarbageTime  [{}] ms", (Object)OsgiUtil.toString((Object)configuration.get("scheduler.expression"), (String)""), (Object)this.chunkCleanUpAge);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

