/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlethelpers.CookieSupport;
import org.apache.sling.servlethelpers.HeaderSupport;
import org.apache.sling.servlethelpers.MockHttpSession;
import org.apache.sling.servlethelpers.MockRequestDispatcherFactory;
import org.apache.sling.servlethelpers.MockRequestParameter;
import org.apache.sling.servlethelpers.MockRequestParameterMap;
import org.apache.sling.servlethelpers.MockRequestPathInfo;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public class MockSlingHttpServletRequest
extends SlingAdaptable
implements SlingHttpServletRequest {
    private final ResourceResolver resourceResolver;
    private final RequestPathInfo requestPathInfo;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private Map<String, MockRequestParameter[]> parameterMap = new LinkedHashMap<String, MockRequestParameter[]>();
    private HttpSession session;
    private Resource resource;
    private String authType;
    private String contextPath;
    private String queryString;
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private String servletPath = "";
    private String pathInfo = null;
    private String method = "GET";
    private final HeaderSupport headerSupport = new HeaderSupport();
    private final CookieSupport cookieSupport = new CookieSupport();
    private String contentType;
    private String characterEncoding;
    private byte[] content;
    private String remoteUser;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort;
    private Locale locale = Locale.US;
    private boolean getInputStreamCalled;
    private boolean getReaderCalled;
    private MockRequestDispatcherFactory requestDispatcherFactory;
    private String responseContentType;
    protected static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return new Object[0][0];
        }
    };

    public MockSlingHttpServletRequest(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.requestPathInfo = this.newMockRequestPathInfo();
    }

    protected MockHttpSession newMockHttpSession() {
        return new MockHttpSession();
    }

    protected MockRequestPathInfo newMockRequestPathInfo() {
        return new MockRequestPathInfo(this.resourceResolver);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            this.session = this.newMockHttpSession();
        }
        return this.session;
    }

    public RequestPathInfo getRequestPathInfo() {
        return this.requestPathInfo;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return IteratorUtils.asEnumeration(this.attributeMap.keySet().iterator());
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributeMap.put(name, object);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getParameter(String name) {
        MockRequestParameter[] params = this.parameterMap.get(name);
        if (params != null && params.length > 0) {
            return params[0].getString();
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, MockRequestParameter[]> entry : this.parameterMap.entrySet()) {
            MockRequestParameter[] values = entry.getValue();
            String[] resultValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                resultValues[i] = values[i].getString();
            }
            result.put(entry.getKey(), resultValues);
        }
        return result;
    }

    public Enumeration<String> getParameterNames() {
        return IteratorUtils.asEnumeration(this.parameterMap.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        MockRequestParameter[] param = this.parameterMap.get(name);
        if (param != null) {
            String[] values = new String[param.length];
            for (int i = 0; i < param.length; ++i) {
                values[i] = param[i].getString();
            }
            return values;
        }
        return null;
    }

    public void setParameterMap(Map<String, Object> parameterMap) {
        this.parameterMap.clear();
        for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String[]) {
                String[] array = (String[])value;
                MockRequestParameter[] values = new MockRequestParameter[array.length];
                for (int i = 0; i < array.length; ++i) {
                    values[i] = new MockRequestParameter(key, array[i]);
                }
                this.parameterMap.put(key, values);
                continue;
            }
            if (value instanceof MockRequestParameter[]) {
                this.parameterMap.put(key, (MockRequestParameter[])value);
                continue;
            }
            if (value != null) {
                this.addRequestParameter(key, value.toString());
                continue;
            }
            this.parameterMap.put(key, null);
        }
        try {
            this.queryString = MockSlingHttpServletRequest.formatQueryString(this.parameterMap);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String formatQueryString(Map<String, MockRequestParameter[]> map) throws UnsupportedEncodingException {
        StringBuilder querystring = new StringBuilder();
        for (Map.Entry<String, MockRequestParameter[]> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            MockSlingHttpServletRequest.formatQueryStringParameter(querystring, entry);
        }
        return querystring.length() > 0 ? querystring.toString() : null;
    }

    private static void formatQueryStringParameter(StringBuilder querystring, Map.Entry<String, MockRequestParameter[]> entry) throws UnsupportedEncodingException {
        for (MockRequestParameter value : entry.getValue()) {
            if (querystring.length() != 0) {
                querystring.append('&');
            }
            querystring.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            querystring.append('=');
            if (value.getString() == null) continue;
            querystring.append(URLEncoder.encode(value.getString(), "UTF-8"));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        try {
            this.parseQueryString(this.parameterMap, this.queryString);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void parseQueryString(Map<String, MockRequestParameter[]> map, String query) throws UnsupportedEncodingException {
        LinkedHashMap queryPairs = new LinkedHashMap();
        String[] pairs = query.split("&");
        for (String pair : pairs) {
            String key;
            int idx = pair.indexOf(61);
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new ArrayList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            ((List)queryPairs.get(key)).add(value);
        }
        map.clear();
        for (Map.Entry entry : queryPairs.entrySet()) {
            List valueList = (List)entry.getValue();
            int numEntries = valueList.size();
            MockRequestParameter[] values = new MockRequestParameter[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                values[i] = new MockRequestParameter((String)entry.getKey(), (String)valueList.get(i));
            }
            map.put((String)entry.getKey(), values);
        }
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public boolean isSecure() {
        return StringUtils.equals((CharSequence)"https", (CharSequence)this.getScheme());
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public long getDateHeader(String name) {
        return this.headerSupport.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.headerSupport.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return HeaderSupport.toEnumeration(this.headerSupport.getHeaderNames());
    }

    public Enumeration<String> getHeaders(String name) {
        return HeaderSupport.toEnumeration(this.headerSupport.getHeaders(name));
    }

    public int getIntHeader(String name) {
        return this.headerSupport.getIntHeader(name);
    }

    public void addHeader(String name, String value) {
        this.headerSupport.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.headerSupport.addIntHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        this.headerSupport.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.headerSupport.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headerSupport.setIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.headerSupport.setDateHeader(name, date);
    }

    public Cookie getCookie(String name) {
        return this.cookieSupport.getCookie(name);
    }

    public Cookie[] getCookies() {
        return this.cookieSupport.getCookies();
    }

    public void addCookie(Cookie cookie) {
        this.cookieSupport.addCookie(cookie);
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.getResourceBundle(null, locale);
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return EMPTY_RESOURCE_BUNDLE;
    }

    public RequestParameter getRequestParameter(String name) {
        MockRequestParameter[] params = this.parameterMap.get(name);
        if (params != null && params.length > 0) {
            return params[0];
        }
        return null;
    }

    public RequestParameterMap getRequestParameterMap() {
        MockRequestParameterMap map = new MockRequestParameterMap();
        for (Map.Entry<String, String[]> entry : this.getParameterMap().entrySet()) {
            map.put(entry.getKey(), this.getRequestParameters(entry.getKey()));
        }
        return map;
    }

    public RequestParameter[] getRequestParameters(String name) {
        return this.parameterMap.get(name);
    }

    public List<RequestParameter> getRequestParameterList() {
        ArrayList<RequestParameter> params = new ArrayList<RequestParameter>();
        for (RequestParameter[] requestParameters : this.getRequestParameterMap().values()) {
            params.addAll(Arrays.asList(requestParameters));
        }
        return params;
    }

    public void addRequestParameter(String name, String value) {
        MockRequestParameter mockRequestParameter = new MockRequestParameter(name, value);
        this.addMockRequestParameter(name, mockRequestParameter);
    }

    public void addRequestParameter(String name, byte[] content, String contentType) {
        MockRequestParameter mockRequestParameter = new MockRequestParameter(name, content, contentType);
        this.addMockRequestParameter(name, mockRequestParameter);
    }

    public void addRequestParameter(String name, byte[] content, String contentType, String filename) {
        MockRequestParameter mockRequestParameter = new MockRequestParameter(name, content, contentType, filename);
        this.addMockRequestParameter(name, mockRequestParameter);
    }

    private void addMockRequestParameter(String name, MockRequestParameter mockRequestParameter) {
        if (this.parameterMap.containsKey(name)) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])this.parameterMap.get(name)));
            list.add(mockRequestParameter);
            this.parameterMap.put(name, list.toArray(new MockRequestParameter[0]));
        } else {
            this.parameterMap.put(name, new MockRequestParameter[]{mockRequestParameter});
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public String getContentType() {
        if (this.contentType == null) {
            return null;
        }
        return this.contentType + (StringUtils.isNotBlank((CharSequence)this.characterEncoding) ? ";charset=" + this.characterEncoding : "");
    }

    public void setContentType(String type) {
        this.contentType = type;
        if (StringUtils.contains((CharSequence)this.contentType, (CharSequence)";charset=")) {
            this.characterEncoding = StringUtils.substringAfter((String)this.contentType, (String)";charset=");
            this.contentType = StringUtils.substringBefore((String)this.contentType, (String)";charset=");
        }
    }

    public ServletInputStream getInputStream() {
        if (this.getReaderCalled) {
            throw new IllegalStateException();
        }
        this.getInputStreamCalled = true;
        return new ServletInputStream(){
            private final InputStream is;
            {
                this.is = MockSlingHttpServletRequest.this.content == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(MockSlingHttpServletRequest.this.content);
            }

            public int read() throws IOException {
                return this.is.read();
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                throw new UnsupportedOperationException();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.requestDispatcherFactory == null) {
            throw new IllegalStateException("Please provdide a MockRequestDispatcherFactory (setRequestDispatcherFactory).");
        }
        return this.requestDispatcherFactory.getRequestDispatcher(path, null);
    }

    public RequestDispatcher getRequestDispatcher(String path, RequestDispatcherOptions options) {
        if (this.requestDispatcherFactory == null) {
            throw new IllegalStateException("Please provdide a MockRequestDispatcherFactory (setRequestDispatcherFactory).");
        }
        return this.requestDispatcherFactory.getRequestDispatcher(path, options);
    }

    public RequestDispatcher getRequestDispatcher(Resource resource) {
        if (this.requestDispatcherFactory == null) {
            throw new IllegalStateException("Please provdide a MockRequestDispatcherFactory (setRequestDispatcherFactory).");
        }
        return this.requestDispatcherFactory.getRequestDispatcher(resource, null);
    }

    public RequestDispatcher getRequestDispatcher(Resource resource, RequestDispatcherOptions options) {
        if (this.requestDispatcherFactory == null) {
            throw new IllegalStateException("Please provdide a MockRequestDispatcherFactory (setRequestDispatcherFactory).");
        }
        return this.requestDispatcherFactory.getRequestDispatcher(resource, options);
    }

    public void setRequestDispatcherFactory(MockRequestDispatcherFactory requestDispatcherFactory) {
        this.requestDispatcherFactory = requestDispatcherFactory;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getPathInfo() {
        if (this.pathInfo != null) {
            return this.pathInfo;
        }
        RequestPathInfo requestPathInfo = this.getRequestPathInfo();
        if (StringUtils.isEmpty((CharSequence)requestPathInfo.getResourcePath())) {
            return null;
        }
        StringBuilder pathInfo = new StringBuilder();
        pathInfo.append(requestPathInfo.getResourcePath());
        if (StringUtils.isNotEmpty((CharSequence)requestPathInfo.getSelectorString())) {
            pathInfo.append('.');
            pathInfo.append(requestPathInfo.getSelectorString());
        }
        if (StringUtils.isNotEmpty((CharSequence)requestPathInfo.getExtension())) {
            pathInfo.append('.');
            pathInfo.append(requestPathInfo.getExtension());
        }
        if (StringUtils.isNotEmpty((CharSequence)requestPathInfo.getSuffix())) {
            pathInfo.append(requestPathInfo.getSuffix());
        }
        return pathInfo.toString();
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getRequestURI() {
        StringBuilder requestUri = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.getServletPath())) {
            requestUri.append(this.getServletPath());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPathInfo())) {
            requestUri.append(this.getPathInfo());
        }
        if (StringUtils.isEmpty((CharSequence)requestUri)) {
            return "/";
        }
        return requestUri.toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer requestUrl = new StringBuffer();
        requestUrl.append(this.getScheme());
        requestUrl.append("://");
        requestUrl.append(this.getServerName());
        if (StringUtils.equals((CharSequence)this.getScheme(), (CharSequence)"http") && this.getServerPort() != 80 || StringUtils.equals((CharSequence)this.getScheme(), (CharSequence)"https") && this.getServerPort() != 443) {
            requestUrl.append(':');
            requestUrl.append(this.getServerPort());
        }
        requestUrl.append(this.getRequestURI());
        return requestUrl;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public RequestProgressTracker getRequestProgressTracker() {
        throw new UnsupportedOperationException();
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public Enumeration<String> getResponseContentTypes() {
        return Collections.enumeration(Collections.singleton(this.responseContentType));
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException();
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        throw new UnsupportedOperationException();
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException();
    }

    public Enumeration<Locale> getLocales() {
        throw new UnsupportedOperationException();
    }

    public String getProtocol() {
        throw new UnsupportedOperationException();
    }

    public BufferedReader getReader() {
        String content;
        if (this.getInputStreamCalled) {
            throw new IllegalStateException();
        }
        this.getReaderCalled = true;
        if (this.content == null) {
            return new BufferedReader(new StringReader(""));
        }
        try {
            content = this.characterEncoding == null ? new String(this.content, Charset.defaultCharset()) : new String(this.content, this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            content = new String(this.content, Charset.defaultCharset());
        }
        return new BufferedReader(new StringReader(content));
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void login(String pUsername, String password) {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() {
        throw new UnsupportedOperationException();
    }

    public Part getPart(String name) {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncStarted() {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncSupported() {
        throw new UnsupportedOperationException();
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException();
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException();
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException();
    }
}

