/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.ServiceUserValidator;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.apache.sling.serviceusermapping.impl.MappingConfigAmendment;
import org.apache.sling.serviceusermapping.impl.ServiceUserMappedImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Service User Mapper Service", description="Configuration for the service mapping service names to names of users.")
@Service(value={ServiceUserMapper.class, ServiceUserMapperImpl.class})
@References(value={@Reference(name="amendment", referenceInterface=MappingConfigAmendment.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, updated="updateAmendment"), @Reference(name="serviceUserValidator ", referenceInterface=ServiceUserValidator.class, bind="bindServiceUserValidator", unbind="unbindServiceUserValidator", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class ServiceUserMapperImpl
implements ServiceUserMapper {
    @Property(label="Service Mappings", description="Provides mappings from service name to user names. Each entry is of the form 'bundleId [ \":\" subServiceName ] \"=\" userName' where bundleId and subServiceName identify the service and userName defines the name of the user to provide to the service. Invalid entries are logged and ignored.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_SERVICE2USER_MAPPING = "user.mapping";
    private static final String[] PROP_SERVICE2USER_MAPPING_DEFAULT = new String[0];
    private static final String PROP_DEFAULT_USER = "user.default";
    @Property(name="user.default", label="Default User", description="The name of the user to use as the default if no service mappingapplies. If this property is missing or empty no default user is defined.")
    private static final String PROP_DEFAULT_USER_DEFAULT = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Mapping[] globalServiceUserMappings = new Mapping[0];
    private String defaultUser;
    private Map<Long, MappingConfigAmendment> amendments = new HashMap<Long, MappingConfigAmendment>();
    private Mapping[] activeMappings = new Mapping[0];
    private final List<ServiceUserValidator> validators = new CopyOnWriteArrayList<ServiceUserValidator>();
    private SortedMap<Mapping, Registration> activeRegistrations = new TreeMap<Mapping, Registration>();
    private BundleContext bundleContext;
    private ExecutorService executorService;
    public boolean registerAsync = true;

    @Activate
    @Modified
    synchronized void configure(BundleContext bundleContext, Map<String, Object> config) {
        if (this.registerAsync && this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        String[] props = PropertiesUtil.toStringArray((Object)config.get(PROP_SERVICE2USER_MAPPING), (String[])PROP_SERVICE2USER_MAPPING_DEFAULT);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(props.length);
        for (String prop : props) {
            if (prop == null || prop.trim().length() <= 0) continue;
            try {
                Mapping mapping = new Mapping(prop.trim());
                mappings.add(mapping);
            }
            catch (IllegalArgumentException iae) {
                this.log.error("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
            }
        }
        this.globalServiceUserMappings = mappings.toArray(new Mapping[mappings.size()]);
        this.defaultUser = PropertiesUtil.toString((Object)config.get(PROP_DEFAULT_USER), (String)PROP_DEFAULT_USER_DEFAULT);
        RegistrationSet registrationSet = null;
        this.bundleContext = bundleContext;
        registrationSet = this.updateMappings();
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    @Deactivate
    synchronized void deactivate() {
        RegistrationSet registrationSet = null;
        this.updateServiceRegistrations(new Mapping[0]);
        this.bundleContext = null;
        this.executeServiceRegistrationsAsync(registrationSet);
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    private void restartAllActiveServiceUserMappedServices() {
        RegistrationSet registrationSet = new RegistrationSet();
        registrationSet.removed = this.activeRegistrations.values();
        registrationSet.added = this.activeRegistrations.values();
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    protected synchronized void bindServiceUserValidator(ServiceUserValidator serviceUserValidator) {
        this.validators.add(serviceUserValidator);
        this.restartAllActiveServiceUserMappedServices();
    }

    protected synchronized void unbindServiceUserValidator(ServiceUserValidator serviceUserValidator) {
        this.validators.remove(serviceUserValidator);
        this.restartAllActiveServiceUserMappedServices();
    }

    @Override
    public String getServiceUserID(Bundle bundle, String subServiceName) {
        String serviceName = ServiceUserMapperImpl.getServiceName(bundle);
        String userId = this.internalGetUserId(serviceName, subServiceName);
        return this.isValidUser(userId, serviceName, subServiceName) ? userId : null;
    }

    protected synchronized void bindAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        Long key = (Long)props.get("service.id");
        RegistrationSet registrationSet = null;
        this.amendments.put(key, amendment);
        registrationSet = this.updateMappings();
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    protected synchronized void unbindAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        Long key = (Long)props.get("service.id");
        RegistrationSet registrationSet = null;
        if (this.amendments.remove(key) != null) {
            registrationSet = this.updateMappings();
        }
        this.executeServiceRegistrationsAsync(registrationSet);
    }

    protected void updateAmendment(MappingConfigAmendment amendment, Map<String, Object> props) {
        this.bindAmendment(amendment, props);
    }

    protected RegistrationSet updateMappings() {
        ArrayList<MappingConfigAmendment> sortedMappings = new ArrayList<MappingConfigAmendment>();
        for (MappingConfigAmendment amendment : this.amendments.values()) {
            sortedMappings.add(amendment);
        }
        Collections.sort(sortedMappings);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (Mapping m : this.globalServiceUserMappings) {
            mappings.add(m);
        }
        for (MappingConfigAmendment mca : sortedMappings) {
            for (Mapping m : mca.getServiceUserMappings()) {
                mappings.add(m);
            }
        }
        this.activeMappings = mappings.toArray(new Mapping[mappings.size()]);
        RegistrationSet registrationSet = this.updateServiceRegistrations(this.activeMappings);
        return registrationSet;
    }

    RegistrationSet updateServiceRegistrations(Mapping[] newMappings) {
        RegistrationSet result = new RegistrationSet();
        if (this.bundleContext == null) {
            return result;
        }
        TreeSet<Mapping> orderedNewMappings = new TreeSet<Mapping>(Arrays.asList(newMappings));
        TreeMap<Mapping, Registration> newRegistrations = new TreeMap<Mapping, Registration>();
        for (Map.Entry<Mapping, Registration> registrationEntry : this.activeRegistrations.entrySet()) {
            boolean keepEntry = true;
            if (!orderedNewMappings.contains(registrationEntry.getKey())) {
                Registration registration = registrationEntry.getValue();
                result.removed.add(registration);
                keepEntry = false;
            }
            if (!keepEntry) continue;
            newRegistrations.put(registrationEntry.getKey(), registrationEntry.getValue());
        }
        for (Mapping mapping : orderedNewMappings) {
            if (newRegistrations.containsKey(mapping)) continue;
            Registration registration = new Registration(mapping);
            newRegistrations.put(mapping, registration);
            result.added.add(registration);
        }
        this.activeRegistrations = newRegistrations;
        return result;
    }

    private void executeServiceRegistrationsAsync(final RegistrationSet registrationSet) {
        if (this.executorService == null) {
            this.executeServiceRegistrations(registrationSet);
        } else {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    ServiceUserMapperImpl.this.executeServiceRegistrations(registrationSet);
                }
            });
        }
    }

    private void executeServiceRegistrations(RegistrationSet registrationSet) {
        if (registrationSet == null) {
            return;
        }
        for (Registration registration : registrationSet.removed) {
            ServiceRegistration serviceRegistration = registration.setService(null);
            if (serviceRegistration == null) continue;
            try {
                serviceRegistration.unregister();
            }
            catch (IllegalStateException e) {
                this.log.error("cannot unregister ServiceUserMapped {}", (Object)registration.mapping, (Object)e);
            }
        }
        BundleContext savedBundleContext = this.bundleContext;
        if (savedBundleContext == null) {
            return;
        }
        for (Registration registration : registrationSet.added) {
            Mapping mapping = registration.mapping;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (mapping.getSubServiceName() != null) {
                ((Dictionary)properties).put("subServiceName", mapping.getSubServiceName());
            }
            ((Dictionary)properties).put(Mapping.SERVICENAME, mapping.getServiceName());
            ServiceRegistration serviceRegistration = savedBundleContext.registerService(ServiceUserMappedImpl.SERVICEUSERMAPPED, (Object)new ServiceUserMappedImpl(), properties);
            ServiceRegistration oldServiceRegistration = registration.setService(serviceRegistration);
            if (oldServiceRegistration == null) continue;
            try {
                oldServiceRegistration.unregister();
            }
            catch (IllegalStateException e) {
                this.log.error("cannot unregister ServiceUserMapped {}", (Object)registration.mapping, (Object)e);
            }
        }
    }

    private String internalGetUserId(String serviceName, String subServiceName) {
        String userId;
        for (Mapping mapping : this.activeMappings) {
            userId = mapping.map(serviceName, subServiceName);
            if (userId == null) continue;
            return userId;
        }
        for (Mapping mapping : this.activeMappings) {
            userId = mapping.map(serviceName, null);
            if (userId == null) continue;
            return userId;
        }
        return this.defaultUser;
    }

    private boolean isValidUser(String userId, String serviceName, String subServiceName) {
        if (userId == null) {
            return false;
        }
        if (!this.validators.isEmpty()) {
            for (ServiceUserValidator validator : this.validators) {
                if (!validator.isValid(userId, serviceName, subServiceName)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static String getServiceName(Bundle bundle) {
        return bundle.getSymbolicName();
    }

    List<Mapping> getActiveMappings() {
        return Collections.unmodifiableList(Arrays.asList(this.activeMappings));
    }

    class RegistrationSet {
        Collection<Registration> added = new ArrayList<Registration>();
        Collection<Registration> removed = new ArrayList<Registration>();

        RegistrationSet() {
        }
    }

    class Registration {
        private Mapping mapping;
        private ServiceRegistration serviceRegistration;

        Registration(Mapping mapping) {
            this.mapping = mapping;
            this.serviceRegistration = null;
        }

        synchronized ServiceRegistration setService(ServiceRegistration serviceRegistration) {
            ServiceRegistration oldServiceRegistration = this.serviceRegistration;
            this.serviceRegistration = serviceRegistration;
            return oldServiceRegistration;
        }
    }
}

