/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;

@Component
@Service(value={InventoryPrinter.class})
@Properties(value={@Property(name="felix.inventory.printer.format", value={"JSON", "TEXT"}), @Property(name="felix.inventory.printer.name", value={"slingserviceusers"}), @Property(name="felix.inventory.printer.title", value={"Sling Service User Mappings"}), @Property(name="felix.inventory.printer.webconsole", boolValue={true})})
public class MappingInventoryPrinter
implements InventoryPrinter {
    @Reference
    private ServiceUserMapperImpl mapper;

    public void print(PrintWriter out, Format format, boolean isZip) {
        try {
            if (format.equals(Format.JSON)) {
                this.renderJson(out);
            } else if (format.equals(Format.TEXT)) {
                this.renderText(out);
            }
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
    }

    private String getMappedUser(Mapping m) {
        return m.map(m.getServiceName(), m.getSubServiceName());
    }

    private SortedMap<String, List<Mapping>> getMappingsByUser(List<Mapping> mappings) {
        TreeMap<String, List<Mapping>> result = new TreeMap<String, List<Mapping>>();
        for (Mapping m : mappings) {
            String user = this.getMappedUser(m);
            ArrayList<Mapping> list = (ArrayList<Mapping>)result.get(user);
            if (list == null) {
                list = new ArrayList<Mapping>();
                result.put(user, list);
            }
            list.add(m);
        }
        return result;
    }

    private void asJSON(JSONWriter w, Mapping m) throws JSONException {
        w.object();
        w.key("serviceName").value((Object)m.getServiceName());
        w.key("subServiceName").value((Object)m.getSubServiceName());
        w.key("user").value((Object)this.getMappedUser(m));
        w.endObject();
    }

    private void renderJson(PrintWriter out) throws JSONException {
        List<Mapping> data = this.mapper.getActiveMappings();
        SortedMap<String, List<Mapping>> byUser = this.getMappingsByUser(data);
        JSONWriter w = new JSONWriter((Writer)out);
        w.setTidy(true);
        w.object();
        w.key("title").value((Object)"Service User Mappings");
        w.key("mappingsCount").value((long)data.size());
        w.key("uniqueUsersCount").value((long)byUser.keySet().size());
        w.key("mappingsByUser");
        w.object();
        for (Map.Entry e : byUser.entrySet()) {
            w.key((String)e.getKey());
            w.array();
            for (Mapping m : (List)e.getValue()) {
                this.asJSON(w, m);
            }
            w.endArray();
        }
        w.endObject();
        w.endObject();
    }

    private void asText(PrintWriter w, Mapping m, String indent) {
        String SEP = " / ";
        w.print(indent);
        w.print(m.getServiceName());
        w.print(" / ");
        String sub = m.getSubServiceName();
        w.print(sub == null ? "" : sub);
        w.print(" / ");
        w.println(this.getMappedUser(m));
    }

    private void renderText(PrintWriter out) {
        List<Mapping> data = this.mapper.getActiveMappings();
        SortedMap<String, List<Mapping>> byUser = this.getMappingsByUser(data);
        String formatInfo = " (format: service name / sub service name / user)";
        out.print("*** Mappings by user (");
        out.print(byUser.keySet().size());
        out.print(" users):");
        out.println(" (format: service name / sub service name / user)");
        for (Map.Entry e : byUser.entrySet()) {
            out.print("  ");
            out.println((String)e.getKey());
            for (Mapping m : (List)e.getValue()) {
                this.asText(out, m, "    ");
            }
        }
    }

    protected void bindMapper(ServiceUserMapperImpl serviceUserMapperImpl) {
        this.mapper = serviceUserMapperImpl;
    }

    protected void unbindMapper(ServiceUserMapperImpl serviceUserMapperImpl) {
        if (this.mapper == serviceUserMapperImpl) {
            this.mapper = null;
        }
    }
}

