/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="Apache Sling Service User Mapper Service", description="Configuration for the service mapping service names to names of users.")
@Service(value={ServiceUserMapper.class})
public class ServiceUserMapperImpl
implements ServiceUserMapper {
    @Property(label="Service Mappings", description="Provides mappings from service name to user names. Each entry is of the form 'serviceName [ \":\" subServiceName ] \"=\" userName' where serviceName and subServiceName identify the service and userName defines the name of the user to provide to the service. Invalid entries are logged and ignored.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_SERVICE2USER_MAPPING = "user.mapping";
    private static final String[] PROP_SERVICE2USER_MAPPING_DEFAULT = new String[0];
    private static final String PROP_DEFAULT_USER = "user.default";
    @Property(name="user.default", label="Default User", description="The name of the user to use as the default if no service mappingapplies. If this property is missing or empty no default user is defined.")
    private static final String PROP_DEFAULT_USER_DEFAULT = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Mapping[] serviceUserMappings;
    private String defaultUser;

    @Activate
    @Modified
    void configure(Map<String, Object> config) {
        String[] props = PropertiesUtil.toStringArray((Object)config.get(PROP_SERVICE2USER_MAPPING), (String[])PROP_SERVICE2USER_MAPPING_DEFAULT);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>(props.length);
        for (String prop : props) {
            if (prop == null) continue;
            try {
                Mapping mapping = new Mapping(prop);
                mappings.add(mapping);
            }
            catch (IllegalArgumentException iae) {
                this.log.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
            }
        }
        this.serviceUserMappings = mappings.toArray(new Mapping[mappings.size()]);
        this.defaultUser = PropertiesUtil.toString((Object)config.get(PROP_DEFAULT_USER), (String)PROP_DEFAULT_USER_DEFAULT);
    }

    @Override
    public String getServiceUserID(Bundle bundle, String subServiceName) {
        String user;
        String serviceName = bundle.getSymbolicName();
        for (Mapping mapping : this.serviceUserMappings) {
            user = mapping.map(serviceName, subServiceName);
            if (user == null) continue;
            return user;
        }
        for (Mapping mapping : this.serviceUserMappings) {
            user = mapping.map(serviceName, null);
            if (user == null) continue;
            return user;
        }
        return this.defaultUser;
    }
}

