/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.html.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.MarkupContext;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.Syntax;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.ElementContext;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.ExpressionParser;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.ExpressionWrapper;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.Fragment;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.Interpolation;
import org.apache.sling.scripting.sightly.impl.compiler.util.SymbolGenerator;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;
import org.apache.sling.scripting.sightly.impl.html.MarkupUtils;
import org.apache.sling.scripting.sightly.impl.plugin.Plugin;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class MarkupHandler {
    private final PushStream stream;
    private final SymbolGenerator symbolGenerator = new SymbolGenerator();
    private final ExpressionParser expressionParser = new ExpressionParser();
    private final Map<String, Plugin> pluginRegistry;
    private final CompilerContext compilerContext;
    private final ExpressionWrapper expressionWrapper;
    private final Stack<ElementContext> elementStack = new Stack();
    private static final Set<String> URI_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("action", "cite", "data", "formaction", "href", "manifest", "poster", "src")));

    public MarkupHandler(PushStream stream, Map<String, Plugin> pluginRegistry, List<Filter> filters, Set<String> knownExpressionOptions) {
        this.stream = stream;
        this.pluginRegistry = pluginRegistry;
        this.expressionWrapper = new ExpressionWrapper(stream, filters, knownExpressionOptions);
        this.compilerContext = new CompilerContext(this.symbolGenerator, this.expressionWrapper, stream);
    }

    public void onOpenTagStart(String markup, String tagName) {
        ElementContext context = new ElementContext(tagName, markup);
        this.elementStack.push(context);
    }

    public void onAttribute(String name, String value, char quoteChar) {
        ElementContext context = this.elementStack.peek();
        if (Syntax.isPluginAttribute(name)) {
            try {
                this.handlePlugin(name, StringUtils.defaultString((String)value, (String)""), context);
            }
            catch (SightlyCompilerException e) {
                if (StringUtils.isEmpty((CharSequence)e.getOffendingInput()) && StringUtils.isNotEmpty((CharSequence)value)) {
                    throw new SightlyCompilerException(e.getMessage(), name + "=" + quoteChar + value + quoteChar);
                }
                throw e;
            }
        } else {
            context.addAttribute(name, value, quoteChar);
        }
    }

    public void onOpenTagEnd(String markup) {
        ElementContext context = this.elementStack.peek();
        PluginInvoke invoke = context.pluginInvoke();
        invoke.beforeElement(this.stream, context.getTagName());
        boolean slyTag = "sly".equalsIgnoreCase(context.getTagName());
        if (slyTag) {
            Patterns.beginStreamIgnore(this.stream);
        }
        invoke.beforeTagOpen(this.stream);
        this.out(context.getOpenTagStartMarkup());
        invoke.beforeAttributes(this.stream);
        this.traverseAttributes(context, invoke);
        invoke.afterAttributes(this.stream);
        this.out(markup);
        invoke.afterTagOpen(this.stream);
        if (slyTag) {
            Patterns.endStreamIgnore(this.stream);
        }
        invoke.beforeChildren(this.stream);
    }

    private void traverseAttributes(ElementContext context, PluginInvoke invoke) {
        for (ElementContext.Attribute attribute : context.getAttributes()) {
            String attrName = attribute.getName();
            Object contentObj = attribute.getValue();
            if (contentObj == null || contentObj instanceof String) {
                String content = (String)contentObj;
                this.emitAttribute(attrName, content, attribute.getQuoteChar(), invoke);
                continue;
            }
            if (!(contentObj instanceof Map.Entry)) continue;
            Map.Entry entry = (Map.Entry)contentObj;
            PluginCallInfo info = (PluginCallInfo)entry.getKey();
            Expression expression = (Expression)entry.getValue();
            invoke.onPluginCall(this.stream, info, expression);
        }
    }

    private void emitAttribute(String name, String content, char quoteChar, PluginInvoke invoke) {
        invoke.beforeAttribute(this.stream, name);
        if (content == null) {
            this.emitSimpleTextAttribute(name, null, quoteChar, invoke);
        } else {
            Interpolation interpolation = this.expressionParser.parseInterpolation(content);
            String text = this.tryAsSimpleText(interpolation);
            if (text != null) {
                this.emitSimpleTextAttribute(name, text, quoteChar, invoke);
            } else {
                this.emitExpressionAttribute(name, interpolation, quoteChar, invoke);
            }
        }
        invoke.afterAttribute(this.stream, name);
    }

    private void emitSimpleTextAttribute(String name, String textValue, char quoteChar, PluginInvoke invoke) {
        this.emitAttributeStart(name);
        invoke.beforeAttributeValue(this.stream, name, new StringConstant(textValue));
        if (textValue != null) {
            this.emitAttributeValueStart(quoteChar);
            textValue = this.escapeQuotes(textValue);
            this.out(textValue);
            this.emitAttributeEnd(quoteChar);
        }
        invoke.afterAttributeValue(this.stream, name);
    }

    private String escapeQuotes(String textValue) {
        return textValue.replace("\"", "&quot;");
    }

    private void emitExpressionAttribute(String name, Interpolation interpolation, char quoteChar, PluginInvoke invoke) {
        if ((interpolation = this.attributeChecked(name, interpolation)).size() == 1) {
            this.emitSingleFragment(name, interpolation, quoteChar, invoke);
        } else {
            this.emitMultipleFragment(name, interpolation, quoteChar, invoke);
        }
    }

    private void emitMultipleFragment(String name, Interpolation interpolation, char quoteChar, PluginInvoke invoke) {
        Expression expression = this.expressionWrapper.transform(interpolation, this.getAttributeMarkupContext(name), ExpressionContext.ATTRIBUTE);
        String attrContent = this.symbolGenerator.next("attrContent");
        this.stream.write(new VariableBinding.Start(attrContent, expression.getRoot()));
        this.emitAttributeStart(name);
        invoke.beforeAttributeValue(this.stream, name, expression.getRoot());
        this.emitAttributeValueStart(quoteChar);
        this.stream.write(new OutputVariable(attrContent));
        this.emitAttributeEnd(quoteChar);
        invoke.afterAttributeValue(this.stream, name);
        this.stream.write(VariableBinding.END);
    }

    private void emitSingleFragment(String name, Interpolation interpolation, char quoteChar, PluginInvoke invoke) {
        RuntimeCall rc;
        Expression valueExpression = this.expressionWrapper.transform(interpolation, null, ExpressionContext.ATTRIBUTE);
        String attrValue = this.symbolGenerator.next("attrValue");
        String attrContent = this.symbolGenerator.next("attrContent");
        String isTrueVar = this.symbolGenerator.next("isTrueAttr");
        String shouldDisplayAttr = this.symbolGenerator.next("shouldDisplayAttr");
        MarkupContext markupContext = this.getAttributeMarkupContext(name);
        boolean alreadyEscaped = false;
        if (valueExpression.getRoot() instanceof RuntimeCall && "xss".equals((rc = (RuntimeCall)valueExpression.getRoot()).getFunctionName())) {
            alreadyEscaped = true;
        }
        ExpressionNode node = valueExpression.getRoot();
        this.stream.write(new VariableBinding.Start(attrValue, node));
        if (!alreadyEscaped) {
            Expression contentExpression = valueExpression.withNode(new Identifier(attrValue));
            this.stream.write(new VariableBinding.Start(attrContent, this.adjustContext(this.compilerContext, contentExpression, markupContext).getRoot()));
            this.stream.write(new VariableBinding.Start(shouldDisplayAttr, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.NEQ, NullLiteral.INSTANCE, new Identifier(attrContent)), new BinaryOperation(BinaryOperator.NEQ, StringConstant.EMPTY, new Identifier(attrContent))), new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.NEQ, StringConstant.EMPTY, new Identifier(attrValue)), new BinaryOperation(BinaryOperator.NEQ, BooleanConstant.FALSE, new Identifier(attrValue))))));
        } else {
            this.stream.write(new VariableBinding.Start(shouldDisplayAttr, new BinaryOperation(BinaryOperator.AND, new BinaryOperation(BinaryOperator.NEQ, StringConstant.EMPTY, new Identifier(attrValue)), new BinaryOperation(BinaryOperator.NEQ, BooleanConstant.FALSE, new Identifier(attrValue)))));
        }
        this.stream.write(new Conditional.Start(shouldDisplayAttr, true));
        this.emitAttributeStart(name);
        invoke.beforeAttributeValue(this.stream, name, node);
        this.stream.write(new VariableBinding.Start(isTrueVar, new BinaryOperation(BinaryOperator.EQ, new Identifier(attrValue), BooleanConstant.TRUE)));
        this.stream.write(new Conditional.Start(isTrueVar, false));
        this.emitAttributeValueStart(quoteChar);
        if (!alreadyEscaped) {
            this.stream.write(new OutputVariable(attrContent));
        } else {
            this.stream.write(new OutputVariable(attrValue));
        }
        this.emitAttributeEnd(quoteChar);
        this.stream.write(Conditional.END);
        this.stream.write(VariableBinding.END);
        invoke.afterAttributeValue(this.stream, name);
        this.stream.write(Conditional.END);
        this.stream.write(VariableBinding.END);
        if (!alreadyEscaped) {
            this.stream.write(VariableBinding.END);
        }
        this.stream.write(VariableBinding.END);
    }

    private void emitAttributeStart(String name) {
        this.out(" " + name);
    }

    private void emitAttributeValueStart(char quoteChar) {
        char quote = '\"';
        if (quoteChar != '\u0000') {
            quote = quoteChar;
        }
        this.out("=");
        this.out(String.valueOf(quote));
    }

    private void emitAttributeEnd(char quoteChar) {
        char quote = '\"';
        if (quoteChar != '\u0000') {
            quote = quoteChar;
        }
        this.out(String.valueOf(quote));
    }

    public void onCloseTag(String markup) {
        ElementContext context = this.elementStack.pop();
        PluginInvoke invoke = context.pluginInvoke();
        invoke.afterChildren(this.stream);
        boolean selfClosingTag = StringUtils.isEmpty((CharSequence)markup);
        boolean slyTag = "sly".equalsIgnoreCase(context.getTagName());
        if (slyTag) {
            Patterns.beginStreamIgnore(this.stream);
        }
        invoke.beforeTagClose(this.stream, selfClosingTag);
        this.out(markup);
        invoke.afterTagClose(this.stream, selfClosingTag);
        if (slyTag) {
            Patterns.endStreamIgnore(this.stream);
        }
        invoke.afterElement(this.stream);
    }

    public void onText(String text) {
        String tag = this.currentElementTag();
        boolean explicitContextRequired = this.isExplicitContextRequired(tag);
        MarkupContext markupContext = explicitContextRequired ? null : MarkupContext.TEXT;
        this.outText(text, markupContext);
    }

    public void onComment(String markup) {
        if (!Syntax.isSightlyComment(markup)) {
            this.outText(markup, MarkupContext.COMMENT);
        }
    }

    public void onDataNode(String markup) {
        this.out(markup);
    }

    public void onDocType(String markup) {
        this.out(markup);
    }

    public void onDocumentFinished() {
        this.stream.close();
    }

    private void outText(String content, MarkupContext context) {
        String text;
        Interpolation interpolation = this.expressionParser.parseInterpolation(content);
        if (context == null) {
            interpolation = this.requireContext(interpolation);
        }
        if ((text = this.tryAsSimpleText(interpolation)) != null) {
            this.out(text);
        } else {
            this.outExprNode(this.expressionWrapper.transform(interpolation, context, ExpressionContext.TEXT).getRoot());
        }
    }

    private Interpolation requireContext(Interpolation interpolation) {
        Interpolation result = new Interpolation();
        for (Fragment fragment : interpolation.getFragments()) {
            Fragment addedFragment;
            if (fragment.isString()) {
                addedFragment = fragment;
            } else if (fragment.getExpression().containsOption("context")) {
                addedFragment = fragment;
            } else {
                String currentTag = this.currentElementTag();
                String warningMessage = String.format("Element %s requires that all expressions have an explicit context specified. The expression will be replaced with an empty string.", currentTag);
                this.stream.warn(new PushStream.StreamMessage(warningMessage, fragment.getExpression().getRawText()));
                addedFragment = new Fragment.Expr(new Expression(StringConstant.EMPTY));
            }
            result.addFragment(addedFragment);
        }
        return result;
    }

    private Interpolation attributeChecked(String attributeName, Interpolation interpolation) {
        if (!MarkupUtils.isSensitiveAttribute(attributeName)) {
            return interpolation;
        }
        Interpolation newInterpolation = new Interpolation();
        Iterator<Fragment> iterator = interpolation.getFragments().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Fragment fragment;
            Fragment addedFragment = fragment = iterator.next();
            if (fragment.isExpression() && !(expression = fragment.getExpression()).containsOption("context")) {
                String warningMessage = String.format("Expressions within the value of attribute %s need to have an explicit context option. The expression will be replaced with an empty string.", attributeName);
                this.stream.warn(new PushStream.StreamMessage(warningMessage, expression.getRawText()));
                addedFragment = new Fragment.Text("");
            }
            newInterpolation.addFragment(addedFragment);
        }
        return newInterpolation;
    }

    private void outExprNode(ExpressionNode node) {
        String variable = this.symbolGenerator.next();
        this.stream.write(new VariableBinding.Start(variable, node));
        this.stream.write(new OutputVariable(variable));
        this.stream.write(VariableBinding.END);
    }

    private String tryAsSimpleText(Interpolation interpolation) {
        if (interpolation.size() == 1) {
            Fragment fragment = interpolation.getFragment(0);
            if (fragment.isString()) {
                return fragment.getText();
            }
        } else if (interpolation.size() == 0) {
            return "";
        }
        return null;
    }

    private void out(String text) {
        this.stream.write(new OutText(text));
    }

    private void handlePlugin(String name, String value, ElementContext context) {
        PluginCallInfo callInfo = Syntax.parsePluginAttribute(name);
        if (callInfo != null) {
            Plugin plugin = this.obtainPlugin(callInfo.getName());
            ExpressionContext expressionContext = ExpressionContext.getContextForPlugin(plugin.name());
            Expression expr = this.expressionWrapper.transform(this.expressionParser.parseInterpolation(value), null, expressionContext);
            PluginInvoke invoke = plugin.invoke(expr, callInfo, this.compilerContext);
            context.addPlugin(invoke, plugin.priority());
            context.addPluginCall(name, callInfo, expr);
        }
    }

    private Plugin obtainPlugin(String name) {
        Plugin plugin = this.pluginRegistry.get(name);
        if (plugin == null) {
            throw new SightlyCompilerException(String.format("None of the registered plugins can handle the data-sly-%s block element.", name), "data-sly-" + name);
        }
        return plugin;
    }

    private MarkupContext getAttributeMarkupContext(String attributeName) {
        if (URI_ATTRIBUTES.contains(attributeName.toLowerCase())) {
            return MarkupContext.URI;
        }
        return MarkupContext.ATTRIBUTE;
    }

    private String currentElementTag() {
        if (this.elementStack.isEmpty()) {
            return null;
        }
        ElementContext current = this.elementStack.peek();
        return current.getTagName();
    }

    private boolean isExplicitContextRequired(String parentElementName) {
        return parentElementName != null && ("script".equals(parentElementName) || "style".equals(parentElementName));
    }

    private Expression adjustContext(CompilerContext compilerContext, Expression expression, MarkupContext markupContext) {
        RuntimeCall runtimeCall;
        ExpressionNode root = expression.getRoot();
        if (root instanceof RuntimeCall && (runtimeCall = (RuntimeCall)root).getFunctionName().equals("xss")) {
            return expression;
        }
        return compilerContext.adjustToContext(expression, markupContext, ExpressionContext.ATTRIBUTE);
    }
}

