/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.commons.compiler.source.JavaEscapeHelper;
import org.apache.sling.scripting.jsp.JspServletConfig;
import org.apache.sling.scripting.jsp.jasper.compiler.JspRuntimeContext;
import org.apache.sling.scripting.jsp.jasper.runtime.AnnotationProcessor;
import org.apache.sling.scripting.jsp.jasper.runtime.HttpJspBase;
import org.apache.sling.servlets.resolver.bundle.tracker.BundledRenderUnit;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;

@Component(service={PrecompiledJSPRunner.class})
public class PrecompiledJSPRunner {
    private final ConcurrentHashMap<HttpJspBase, Object> locks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean callPrecompiledJSP(JspRuntimeContext.JspFactoryHandler jspFactoryHandler, JspServletConfig jspServletConfig, SlingBindings bindings) {
        boolean found = false;
        Object jsp = null;
        try {
            jspFactoryHandler.incUsage();
            BundledRenderUnit bundledRenderUnit = (BundledRenderUnit)bindings.get((Object)BundledRenderUnit.VARIABLE);
            if (bundledRenderUnit != null && bundledRenderUnit.getUnit() instanceof HttpJspBase) {
                found = true;
                jsp = (HttpJspBase)((Object)bundledRenderUnit.getUnit());
                if (jsp.getServletConfig() == null) {
                    Object lock;
                    Object object = lock = this.locks.computeIfAbsent((HttpJspBase)((Object)jsp), key -> new Object());
                    synchronized (object) {
                        if (jsp.getServletConfig() == null) {
                            PrecompiledServletConfig servletConfig = new PrecompiledServletConfig(jspServletConfig, bundledRenderUnit);
                            AnnotationProcessor annotationProcessor = (AnnotationProcessor)jspServletConfig.getServletContext().getAttribute(AnnotationProcessor.class.getName());
                            if (annotationProcessor != null) {
                                annotationProcessor.processAnnotations(jsp);
                                annotationProcessor.postConstruct(jsp);
                            }
                            ((HttpJspBase)((Object)jsp)).init(servletConfig);
                        }
                    }
                }
                ((HttpJspBase)((Object)jsp)).service((HttpServletRequest)bindings.getRequest(), (HttpServletResponse)bindings.getResponse());
            }
            jspFactoryHandler.decUsage();
            if (jsp == null) return found;
            this.locks.remove(jsp);
        }
        catch (IllegalAccessException | InvocationTargetException | NamingException e222222) {
            throw new SlingException("Unable to process annotations for servlet " + jsp.getClass().getName() + ".", (Throwable)e222222);
            catch (NoClassDefFoundError e222222) {
                return found;
            }
            catch (IOException e3) {
                throw new SlingIOException(e3);
                catch (ServletException e4) {
                    throw new SlingServletException(e4);
                }
            }
        }
        finally {
            jspFactoryHandler.decUsage();
            if (jsp != null) {
                this.locks.remove(jsp);
            }
        }
        return found;
    }

    private static class PrecompiledServletConfig
    extends JspServletConfig {
        private final BundledRenderUnit bundledRenderUnit;
        private String servletName;

        PrecompiledServletConfig(JspServletConfig jspServletConfig, BundledRenderUnit bundledRenderUnit) {
            super(jspServletConfig.getServletContext(), new HashMap<String, String>(jspServletConfig.getProperties()));
            this.bundledRenderUnit = bundledRenderUnit;
        }

        @Override
        public String getServletName() {
            if (this.servletName == null && this.bundledRenderUnit.getUnit() != null) {
                Bundle bundle = this.bundledRenderUnit.getBundle();
                Object jsp = this.bundledRenderUnit.getUnit();
                String originalName = JavaEscapeHelper.unescapeAll((String)jsp.getClass().getPackage().getName()) + "/" + JavaEscapeHelper.unescapeAll((String)jsp.getClass().getSimpleName());
                this.servletName = bundle.getSymbolicName() + ": " + originalName;
            }
            return this.servletName;
        }
    }
}

