/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.jasper.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ResourceBundleELResolver;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public final class ELResolverImpl
extends ELResolver {
    public static final ELResolver DefaultResolver = new CompositeELResolver();
    private final VariableResolver variableResolver;

    public ELResolverImpl(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            if (property != null) {
                try {
                    return this.variableResolver.resolveVariable(property.toString());
                }
                catch (ELException e) {
                    throw new javax.el.ELException(e.getMessage(), e.getCause());
                }
            }
        }
        if (!context.isPropertyResolved()) {
            return DefaultResolver.getValue(context, base, property);
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            if (property != null) {
                try {
                    Object obj = this.variableResolver.resolveVariable(property.toString());
                    return obj != null ? obj.getClass() : null;
                }
                catch (ELException e) {
                    throw new javax.el.ELException(e.getMessage(), e.getCause());
                }
            }
        }
        if (!context.isPropertyResolved()) {
            return DefaultResolver.getType(context, base, property);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException("Legacy VariableResolver wrapped, not writable");
        }
        if (!context.isPropertyResolved()) {
            DefaultResolver.setValue(context, base, property, value);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, javax.el.ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            context.setPropertyResolved(true);
            return true;
        }
        return DefaultResolver.isReadOnly(context, base, property);
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return DefaultResolver.getFeatureDescriptors(context, base);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return DefaultResolver.getCommonPropertyType(context, base);
    }

    static {
        ((CompositeELResolver)DefaultResolver).add(new MapELResolver());
        ((CompositeELResolver)DefaultResolver).add(new ResourceBundleELResolver());
        ((CompositeELResolver)DefaultResolver).add(new ListELResolver());
        ((CompositeELResolver)DefaultResolver).add(new ArrayELResolver());
        ((CompositeELResolver)DefaultResolver).add(new BeanELResolver());
    }
}

