/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.sling.scripting.jsp.SlingIOProvider;
import org.apache.sling.scripting.jsp.SlingTldLocationsCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspServletContext
implements ServletContext {
    private static final Logger log = LoggerFactory.getLogger(JspServletContext.class);
    private final SlingIOProvider ioProvider;
    private final ServletContext delegatee;
    private final SlingTldLocationsCache tcs;

    JspServletContext(SlingIOProvider ioProvider, ServletContext componentContext, SlingTldLocationsCache tcs) {
        this.ioProvider = ioProvider;
        this.delegatee = componentContext;
        this.tcs = tcs;
    }

    public URL getResource(String path) throws MalformedURLException {
        URL url;
        if (path.startsWith("/") && (url = this.ioProvider.getURL(path)) != null) {
            return url;
        }
        return this.getUrlForResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (path.startsWith("/")) {
            try {
                return this.ioProvider.getInputStream(path);
            }
            catch (Exception ex) {
                log.debug("getResourceAsStream: Cannot get resource {}: {}", (Object)path, (Object)ex.getMessage());
            }
        }
        try {
            URL url = this.getUrlForResource(path);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (Exception e) {
            log.debug("getResourceAsStream: Cannot access resource {} through URL: {}", (Object)path, (Object)e.getMessage());
        }
        return null;
    }

    public Set<?> getResourcePaths(String path) {
        return this.ioProvider.getResourcePaths(path);
    }

    public void log(String msg) {
        log.info(msg);
    }

    @Deprecated
    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        log.error(message, throwable);
    }

    public Object getAttribute(String name) {
        return this.delegatee.getAttribute(name);
    }

    public Enumeration<?> getAttributeNames() {
        return this.delegatee.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this.delegatee.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.delegatee.setAttribute(name, object);
    }

    public ServletContext getContext(String uripath) {
        return this.delegatee.getContext(uripath);
    }

    public String getInitParameter(String name) {
        return this.delegatee.getInitParameter(name);
    }

    public Enumeration<?> getInitParameterNames() {
        return this.delegatee.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.delegatee.getMajorVersion();
    }

    public String getMimeType(String file) {
        return this.delegatee.getMimeType(file);
    }

    public int getMinorVersion() {
        return this.delegatee.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.delegatee.getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.delegatee.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.delegatee.getRequestDispatcher(path);
    }

    public String getServerInfo() {
        return this.delegatee.getServerInfo();
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        return this.delegatee.getServlet(name);
    }

    public String getServletContextName() {
        return this.delegatee.getServletContextName();
    }

    @Deprecated
    public Enumeration<?> getServletNames() {
        return this.delegatee.getServletNames();
    }

    @Deprecated
    public Enumeration<?> getServlets() {
        return this.delegatee.getServlets();
    }

    public String getContextPath() {
        return this.delegatee.getContextPath();
    }

    private URL getUrlForResource(String path) {
        int cs = path.indexOf(":/");
        if (cs > 0 && cs < path.length() - 2) {
            URL url;
            if ((cs += 2) < path.length() && path.charAt(cs) != '/') {
                path = path.substring(0, cs) + "/" + path.substring(cs);
            }
            if ((url = this.tcs.getTldLocationURL(path)) != null) {
                return url;
            }
            try {
                return new URL(path);
            }
            catch (MalformedURLException mue) {
                log.debug("getUrlForResource: Cannot create URL for {}: {}", (Object)path, (Object)mue.getMessage());
            }
        }
        return null;
    }
}

