/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceProviderInfo
implements Comparable<ResourceProviderInfo> {
    private static final Logger logger = LoggerFactory.getLogger(ResourceProviderInfo.class);
    private final ServiceReference ref;
    private final String path;
    private final String name;
    private final boolean useResourceAccessSecurity;
    private final AuthType authType;
    private final boolean modifiable;
    private final boolean adaptable;
    private final boolean refreshable;
    private final boolean attributable;

    public ResourceProviderInfo(ServiceReference ref) {
        this.ref = ref;
        this.path = PropertiesUtil.toString((Object)ref.getProperty("provider.root"), (String)"");
        this.name = PropertiesUtil.toString((Object)ref.getProperty("provider.name"), null);
        this.useResourceAccessSecurity = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.useResourceAccessSecurity"), (boolean)false);
        String authType = PropertiesUtil.toString((Object)ref.getProperty("provider.authenticate"), (String)AuthType.no.name());
        AuthType aType = null;
        try {
            aType = AuthType.valueOf((String)authType);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Illegal auth type {} for resource provider {}", (Object)authType, (Object)this.name);
        }
        this.authType = aType;
        this.modifiable = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.modifiable"), (boolean)false);
        this.adaptable = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.adaptable"), (boolean)false);
        this.refreshable = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.refreshable"), (boolean)false);
        this.attributable = PropertiesUtil.toBoolean((Object)ref.getProperty("provider.attributable"), (boolean)false);
    }

    public boolean isValid() {
        if (!this.path.startsWith("/")) {
            logger.debug("ResourceProvider path does not start with /, invalid: {}", (Object)this.path);
            return false;
        }
        if (this.authType == null) {
            logger.debug("ResourceProvider has null authType, invalid");
            return false;
        }
        return true;
    }

    public ServiceReference getServiceReference() {
        return this.ref;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public int compareTo(ResourceProviderInfo o) {
        int result = this.path.compareTo(o.path);
        if (result == 0) {
            result = o.ref.compareTo((Object)this.ref);
        }
        return result;
    }

    public String toString() {
        return "ResourceProviderInfo [ref=" + this.ref + ", path=" + this.path + ", useResourceAccessSecurity=" + this.useResourceAccessSecurity + ", authType=" + this.authType + ", modifiable=" + this.modifiable + "]";
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isAdaptable() {
        return this.adaptable;
    }

    public boolean isRefreshable() {
        return this.refreshable;
    }

    public boolean isAttributable() {
        return this.attributable;
    }

    public String getName() {
        return this.name;
    }

    public boolean getUseResourceAccessSecurity() {
        return this.useResourceAccessSecurity;
    }
}

