/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.mapping.ResourceMapper;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.JcrNamespaceMangler;
import org.apache.sling.resourceresolver.impl.ResourceTypeUtil;
import org.apache.sling.resourceresolver.impl.helper.RedirectResource;
import org.apache.sling.resourceresolver.impl.helper.ResourceIteratorDecorator;
import org.apache.sling.resourceresolver.impl.helper.ResourcePathIterator;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverContext;
import org.apache.sling.resourceresolver.impl.helper.ResourceResolverControl;
import org.apache.sling.resourceresolver.impl.helper.StarResource;
import org.apache.sling.resourceresolver.impl.helper.URI;
import org.apache.sling.resourceresolver.impl.helper.URIException;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.ResourceMapperImpl;
import org.apache.sling.resourceresolver.impl.params.ParsedParameters;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorageProvider;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Adaptable(adaptableClass=ResourceResolver.class, adapters={@Adapter(value={Session.class}), @Adapter(value={ResourceMapper.class})})
public class ResourceResolverImpl
extends SlingAdaptable
implements ResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolverImpl.class);
    private static final Map<String, String> EMPTY_PARAMETERS = Collections.emptyMap();
    public static final String PROP_REDIRECT_INTERNAL = "sling:internalRedirect";
    public static final String PROP_ALIAS = "sling:alias";
    public static final String JCR_CONTENT_LEAF = "/jcr:content";
    private final CommonResourceResolverFactoryImpl factory;
    private final ResourceResolverControl control;
    private final ResourceResolverContext context;
    protected final Map<ResourceTypeInformation, Boolean> resourceTypeLookupCache = new ConcurrentHashMap<ResourceTypeInformation, Boolean>();
    private volatile Exception closedResolverException;
    private static final String DEFAULT_QUERY_LANGUAGE = "xpath";
    private Object cachedSession;
    private boolean searchedSession = false;

    public ResourceResolverImpl(CommonResourceResolverFactoryImpl factory, boolean isAdmin, Map<String, Object> authenticationInfo) throws LoginException {
        this(factory, isAdmin, authenticationInfo, factory.getResourceProviderTracker());
    }

    ResourceResolverImpl(CommonResourceResolverFactoryImpl factory, boolean isAdmin, Map<String, Object> authenticationInfo, ResourceProviderStorageProvider resourceProviderTracker) throws LoginException {
        this.factory = factory;
        this.context = new ResourceResolverContext(this, factory.getResourceAccessSecurityTracker());
        this.control = this.createControl(resourceProviderTracker, authenticationInfo, isAdmin);
        this.factory.register(this, this.control);
    }

    private ResourceResolverImpl(ResourceResolverImpl resolver, Map<String, Object> authenticationInfo) throws LoginException {
        this.factory = resolver.factory;
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        if (resolver.control.getAuthenticationInfo() != null) {
            authInfo.putAll(resolver.control.getAuthenticationInfo());
        }
        if (authenticationInfo != null) {
            authInfo.putAll(authenticationInfo);
        }
        authInfo.put("provider.auth.clone", true);
        this.context = new ResourceResolverContext(this, this.factory.getResourceAccessSecurityTracker());
        this.control = this.createControl(this.factory.getResourceProviderTracker(), authInfo, resolver.control.isAdmin());
        this.factory.register(this, this.control);
    }

    private ResourceResolverControl createControl(ResourceProviderStorageProvider resourceProviderTracker, Map<String, Object> authenticationInfo, boolean isAdmin) throws LoginException {
        ResourceResolverControl control = new ResourceResolverControl(isAdmin, authenticationInfo, resourceProviderTracker);
        this.context.getProviderManager().authenticateAll(resourceProviderTracker.getResourceProviderStorage().getAuthRequiredHandlers(), control);
        return control;
    }

    public ResourceResolver clone(Map<String, Object> authenticationInfo) throws LoginException {
        this.checkClosed();
        return new ResourceResolverImpl(this, authenticationInfo);
    }

    public boolean isLive() {
        return !this.control.isClosed() && this.control.isLive(this.context) && this.factory.isLive();
    }

    public void close() {
        if (this.factory.shouldLogResourceResolverClosing()) {
            this.closedResolverException = new Exception("Stack Trace");
        }
        this.factory.unregister(this, this.control);
    }

    public void checkClosed() {
        if (this.control.isClosed()) {
            if (this.closedResolverException != null) {
                logger.error("The ResourceResolver has already been closed.", (Throwable)this.closedResolverException);
            }
            throw new IllegalStateException("Resource resolver is already closed.");
        }
        if (!this.factory.isLive()) {
            throw new IllegalStateException("Resource resolver factory which created this resolver is no longer active.");
        }
    }

    public Iterator<String> getAttributeNames() {
        this.checkClosed();
        return this.control.getAttributeNames(this.context).iterator();
    }

    public Object getAttribute(String name) {
        this.checkClosed();
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.control.getAttribute(this.context, name);
    }

    public Resource resolve(String path) {
        this.checkClosed();
        Resource rsrc = this.resolveInternal(null, path);
        return rsrc;
    }

    public Resource resolve(HttpServletRequest request) {
        this.checkClosed();
        Resource rsrc = this.resolveInternal(request, request.getPathInfo());
        return rsrc;
    }

    public Resource resolve(HttpServletRequest request, String path) {
        this.checkClosed();
        Resource rsrc = this.resolveInternal(request, path);
        return rsrc;
    }

    private Resource resolveInternal(HttpServletRequest request, String absPath) {
        if (absPath == null) {
            absPath = "/";
        } else if (!absPath.startsWith("/")) {
            absPath = "/" + absPath;
        }
        absPath = this.unmangleNamespaces(absPath);
        String[] realPathList = new String[]{absPath};
        String requestPath = request != null ? ResourceResolverImpl.getMapPath(request.getScheme(), request.getServerName(), request.getServerPort(), absPath) : ResourceResolverImpl.getMapPath("http", "localhost", 80, absPath);
        logger.debug("resolve: Resolving request path {}", (Object)requestPath);
        for (int i = 0; i < 100; ++i) {
            Object[] mappedPath = null;
            Iterator<MapEntry> mapEntriesIterator = this.factory.getMapEntries().getResolveMapsIterator(requestPath);
            while (mapEntriesIterator.hasNext()) {
                MapEntry mapEntry = mapEntriesIterator.next();
                mappedPath = mapEntry.replace(requestPath);
                if (mappedPath == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("resolve: MapEntry {} matches, mapped path is {}", (Object)mapEntry, (Object)Arrays.toString(mappedPath));
                }
                if (mapEntry.isInternal()) {
                    logger.debug("resolve: Redirecting internally");
                    break;
                }
                logger.debug("resolve: Returning external redirect");
                return this.factory.getResourceDecoratorTracker().decorate((Resource)new RedirectResource(this, absPath, (String)mappedPath[0], mapEntry.getStatus()));
            }
            if (mappedPath == null) {
                logger.debug("resolve: Request path {} does not match any MapEntry", (Object)requestPath);
                break;
            }
            if (!mappedPath[0].contains("://")) {
                logger.debug("resolve: Mapped path is for resource tree");
                realPathList = mappedPath;
                break;
            }
            try {
                URI uri = new URI(mappedPath[0], false);
                requestPath = ResourceResolverImpl.getMapPath(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
                realPathList = new String[]{uri.getPath()};
                logger.debug("resolve: Mapped path is an URL, using new request path {}", (Object)requestPath);
                continue;
            }
            catch (URIException use) {
                throw new ResourceNotFoundException(absPath);
            }
        }
        Object res = null;
        block4: for (int i = 0; res == null && i < realPathList.length; ++i) {
            ParsedParameters parsedPath = new ParsedParameters(realPathList[i]);
            String realPath = parsedPath.getRawPath();
            if (StarResource.appliesTo(realPath)) {
                logger.debug("resolve: Mapped path {} is a Star Resource", (Object)realPath);
                res = new StarResource(this, this.ensureAbsPath(realPath));
                continue;
            }
            if (realPath.startsWith("/")) {
                logger.debug("resolve: Try absolute mapped path {}", (Object)realPath);
                res = this.resolveInternal(realPath, parsedPath.getParameters());
                continue;
            }
            for (String path : this.factory.getSearchPath()) {
                logger.debug("resolve: Try relative mapped path with search path entry {}", (Object)path);
                res = this.resolveInternal(path + realPath, parsedPath.getParameters());
                if (res == null) continue;
                continue block4;
            }
        }
        if (res == null) {
            ParsedParameters parsedPath = new ParsedParameters(realPathList[0]);
            String resourcePath = this.ensureAbsPath(parsedPath.getRawPath());
            logger.debug("resolve: Path {} does not resolve, returning NonExistingResource at {}", (Object)absPath, (Object)resourcePath);
            res = new NonExistingResource((ResourceResolver)this, resourcePath);
            int index = resourcePath.indexOf(46);
            if (index != -1) {
                res.getResourceMetadata().setResolutionPathInfo(resourcePath.substring(index));
            }
            res.getResourceMetadata().setParameterMap(parsedPath.getParameters());
        } else {
            logger.debug("resolve: Path {} resolves to Resource {}", (Object)absPath, res);
        }
        return this.factory.getResourceDecoratorTracker().decorate((Resource)res);
    }

    public String map(String resourcePath) {
        this.checkClosed();
        return this.map(null, resourcePath);
    }

    public String map(HttpServletRequest request, String resourcePath) {
        return this.adaptTo(ResourceMapper.class).getMapping(resourcePath, request);
    }

    public String[] getSearchPath() {
        this.checkClosed();
        List<String> searchPath = this.factory.getSearchPath();
        return searchPath.toArray(new String[searchPath.size()]);
    }

    public Resource getResource(String path) {
        this.checkClosed();
        Resource result = this.getResourceInternal(null, path);
        return result;
    }

    public Resource getResource(Resource base, String path) {
        this.checkClosed();
        String absolutePath = path;
        if (absolutePath != null && !absolutePath.startsWith("/") && base != null && base.getPath() != null) {
            absolutePath = ResourceResolverImpl.appendToPath(base.getPath(), absolutePath);
        }
        Resource result = this.getResourceInternal(base, absolutePath);
        return result;
    }

    private static String appendToPath(String pathWithParameters, String segmentToAppend) {
        ParsedParameters parsed = new ParsedParameters(pathWithParameters);
        if (parsed.getParametersString() == null) {
            return parsed.getRawPath() + '/' + segmentToAppend;
        }
        return parsed.getRawPath() + '/' + segmentToAppend + parsed.getParametersString();
    }

    private Resource getResourceInternal(Resource parent, String path) {
        Resource result;
        block1: {
            String prefix;
            block2: {
                result = null;
                if (path == null) break block1;
                if (!path.startsWith("/")) break block2;
                ParsedParameters parsedPath = new ParsedParameters(path);
                Resource resource = result = (path = ResourceUtil.normalize((String)parsedPath.getRawPath())) != null ? this.getAbsoluteResourceInternal(parent, path, parsedPath.getParameters(), false) : null;
                if (result == null) break block1;
                result = this.factory.getResourceDecoratorTracker().decorate(result);
                break block1;
            }
            Iterator<String> iterator = this.factory.getSearchPath().iterator();
            while (iterator.hasNext() && (result = this.getResource((prefix = iterator.next()) + path)) == null) {
            }
        }
        return result;
    }

    public Iterator<Resource> listChildren(Resource parent) {
        this.checkClosed();
        if (parent instanceof ResourceWrapper) {
            return this.listChildren(((ResourceWrapper)parent).getResource());
        }
        return new ResourceIteratorDecorator(this.factory.getResourceDecoratorTracker(), this.control.listChildren(this.context, parent));
    }

    public Iterable<Resource> getChildren(final Resource parent) {
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                return ResourceResolverImpl.this.listChildren(parent);
            }
        };
    }

    public Iterator<Resource> findResources(String query, String language) throws SlingException {
        this.checkClosed();
        return new ResourceIteratorDecorator(this.factory.getResourceDecoratorTracker(), this.control.findResources(this.context, query, StringUtils.defaultString((String)language, (String)DEFAULT_QUERY_LANGUAGE)));
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) throws SlingException {
        this.checkClosed();
        return this.control.queryResources(this.context, query, StringUtils.defaultString((String)language, (String)DEFAULT_QUERY_LANGUAGE));
    }

    public String getUserID() {
        Object user;
        Object impUser;
        this.checkClosed();
        if (this.control.getAuthenticationInfo() != null) {
            impUser = this.control.getAuthenticationInfo().get("user.impersonation");
            if (impUser != null) {
                return impUser.toString();
            }
            user = this.control.getAuthenticationInfo().get("user.name");
            if (user != null) {
                return user.toString();
            }
        }
        if ((impUser = this.getAttribute("user.impersonation")) != null) {
            return impUser.toString();
        }
        user = this.getAttribute("user.name");
        if (user != null) {
            return user.toString();
        }
        return null;
    }

    private <AdapterType> AdapterType getSession(Class<AdapterType> type) {
        if (!this.searchedSession) {
            this.searchedSession = true;
            this.cachedSession = this.control.adaptTo(this.context, type);
        }
        return (AdapterType)this.cachedSession;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        this.checkClosed();
        if (type.getName().equals("javax.jcr.Session")) {
            return this.getSession(type);
        }
        if (type == ResourceMapper.class) {
            return (AdapterType)new ResourceMapperImpl(this, this.factory.getResourceDecoratorTracker(), this.factory.getMapEntries(), this.factory.getNamespaceMangler());
        }
        AdapterType result = this.control.adaptTo(this.context, type);
        if (result != null) {
            return result;
        }
        return (AdapterType)super.adaptTo(type);
    }

    private static String getMapPath(String scheme, String host, int port, String path) {
        if (port < 0) {
            port = "https".equals(scheme) ? 443 : 80;
        }
        return scheme + "/" + host + "." + port + path;
    }

    public Resource resolveInternal(String absPath, Map<String, String> parameters) {
        Resource resource = null;
        if (absPath != null && !absPath.isEmpty() && !absPath.startsWith("/")) {
            logger.debug("resolveInternal: absolute path expected {} ", (Object)absPath);
            return resource;
        }
        String curPath = absPath;
        try {
            ResourcePathIterator it = new ResourcePathIterator(absPath);
            while (it.hasNext() && resource == null) {
                curPath = it.next();
                resource = this.getAbsoluteResourceInternal(null, curPath, parameters, true);
            }
        }
        catch (Exception ex) {
            throw new SlingException("Problem trying " + curPath + " for request path " + absPath, (Throwable)ex);
        }
        if (resource != null) {
            String rpi = absPath.substring(curPath.length());
            resource.getResourceMetadata().setResolutionPath(absPath.substring(0, curPath.length()));
            resource.getResourceMetadata().setResolutionPathInfo(rpi);
            resource.getResourceMetadata().setParameterMap(parameters);
            logger.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, rpi, absPath});
        } else {
            String tokenizedPath = absPath;
            resource = this.getAbsoluteResourceInternal(null, "/", parameters, true);
            if (resource == null && (resource = this.getAbsoluteResourceInternal(absPath, parameters, true)) != null) {
                tokenizedPath = tokenizedPath.substring(resource.getPath().length());
            }
            StringBuilder resolutionPath = new StringBuilder();
            StringTokenizer tokener = new StringTokenizer(tokenizedPath, "/");
            int delimCount = StringUtils.countMatches((CharSequence)tokenizedPath, (char)'/');
            int redundantDelimCount = delimCount - tokener.countTokens();
            while (resource != null && tokener.hasMoreTokens()) {
                String childNameRaw = tokener.nextToken();
                Resource nextResource = this.getChildInternal(resource, childNameRaw);
                if (nextResource != null) {
                    resource = nextResource;
                    resolutionPath.append("/").append(childNameRaw);
                    continue;
                }
                String childName = null;
                ResourcePathIterator rpi = new ResourcePathIterator(childNameRaw);
                while (rpi.hasNext() && nextResource == null) {
                    childName = rpi.next();
                    nextResource = this.getChildInternal(resource, childName);
                }
                resource = nextResource;
                resolutionPath.append("/").append(childName);
                if (nextResource == null) continue;
                break;
            }
            if (resource != null) {
                String path = resolutionPath.toString();
                String pathInfo = absPath.substring(path.length() + redundantDelimCount);
                resource.getResourceMetadata().setResolutionPath(path);
                resource.getResourceMetadata().setResolutionPathInfo(pathInfo);
                resource.getResourceMetadata().setParameterMap(parameters);
                logger.debug("resolveInternal: Found resource {} with path info {} for {}", new Object[]{resource, pathInfo, absPath});
            }
        }
        return resource;
    }

    private Resource getChildInternal(Resource parent, String childName) {
        String path = childName.startsWith("/") ? childName : parent.getPath() + '/' + childName;
        Resource child = this.getAbsoluteResourceInternal(parent, ResourceUtil.normalize((String)path), EMPTY_PARAMETERS, true);
        if (child != null) {
            String alias = ResourceResolverControl.getProperty(child, PROP_REDIRECT_INTERNAL);
            if (alias != null) {
                logger.warn("getChildInternal: Internal redirect to {} for Resource {} is not supported yet, ignoring", (Object)alias, (Object)child);
            }
            return child;
        }
        if (this.factory.getMapEntries().isOptimizeAliasResolutionEnabled()) {
            String aliasName;
            logger.debug("getChildInternal: Optimize Alias Resolution is Enabled");
            Map<String, String> aliases = this.factory.getMapEntries().getAliasMap(parent.getPath());
            if (aliases != null && (aliasName = aliases.get(childName)) != null) {
                String aliasPath = aliasName.startsWith("/") ? aliasName : parent.getPath() + '/' + aliasName;
                Resource aliasedChild = this.getAbsoluteResourceInternal(parent, ResourceUtil.normalize((String)aliasPath), EMPTY_PARAMETERS, true);
                logger.debug("getChildInternal: Found Resource {} with alias {} to use", (Object)aliasedChild, (Object)childName);
                return aliasedChild;
            }
        } else {
            if (this.factory.isOptimizeAliasResolutionEnabled()) {
                this.factory.getMapEntries().logDisableAliasOptimization();
            }
            logger.debug("getChildInternal: Optimize Alias Resolution is Disabled");
            Iterator<Resource> children = this.listChildren(parent);
            while (children.hasNext()) {
                String[] aliases;
                child = children.next();
                if (child.getPath().endsWith(JCR_CONTENT_LEAF) || (aliases = ResourceResolverControl.getProperty(child, PROP_ALIAS, String[].class)) == null) continue;
                for (String alias : aliases) {
                    if (!childName.equals(alias)) continue;
                    logger.debug("getChildInternal: Found Resource {} with alias {} to use", (Object)child, (Object)childName);
                    Resource aliasedChild = this.getAbsoluteResourceInternal(parent, ResourceUtil.normalize((String)child.getPath()), EMPTY_PARAMETERS, true);
                    return aliasedChild;
                }
            }
        }
        logger.debug("getChildInternal: Resource {} has no child {}", (Object)parent, (Object)childName);
        return null;
    }

    private Resource getAbsoluteResourceInternal(@Nullable Resource parent, @Nullable String path, Map<String, String> parameters, boolean isResolve) {
        if (path == null || path.length() == 0 || path.charAt(0) != '/') {
            logger.debug("getResourceInternal: Path must be absolute {}", (Object)path);
            return null;
        }
        Resource parentToUse = parent != null && path.startsWith(parent.getPath()) ? parent : null;
        Resource resource = this.control.getResource(this.context, path, parentToUse, parameters, isResolve);
        if (resource != null) {
            resource.getResourceMetadata().setResolutionPath(path);
            resource.getResourceMetadata().setParameterMap(parameters);
            return resource;
        }
        logger.debug("getResourceInternal: Cannot resolve path '{}' to a resource", (Object)path);
        return null;
    }

    private Resource getAbsoluteResourceInternal(String absPath, Map<String, String> parameters, boolean isResolved) {
        if (!absPath.contains("/") || "/".equals(absPath)) {
            return null;
        }
        absPath = absPath.substring(absPath.indexOf("/"));
        Resource resource = this.getAbsoluteResourceInternal(null, absPath, parameters, isResolved);
        absPath = absPath.substring(0, absPath.lastIndexOf("/"));
        while (!absPath.equals("")) {
            Resource r = this.getAbsoluteResourceInternal(null, absPath, parameters, true);
            if (r != null) {
                resource = r;
            }
            absPath = absPath.substring(0, absPath.lastIndexOf("/"));
        }
        return resource;
    }

    private String ensureAbsPath(String path) {
        if (!path.startsWith("/")) {
            path = this.factory.getSearchPath().get(0) + path;
        }
        return path;
    }

    private String unmangleNamespaces(String absPath) {
        if (absPath != null && this.factory.getNamespaceMangler() != null) {
            absPath = ((JcrNamespaceMangler)this.factory.getNamespaceMangler()).unmangleNamespaces(this, logger, absPath);
        }
        return absPath;
    }

    public void delete(Resource resource) throws PersistenceException {
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            return;
        }
        this.control.delete(this.context, resource);
    }

    public Resource create(Resource parent, String name, Map<String, Object> properties) throws PersistenceException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.indexOf("/") != -1) {
            throw new IllegalArgumentException("Name should not contain a slash: " + name);
        }
        String path = parent.getPath().equals("/") ? parent.getPath() + name : parent.getPath() + "/" + name;
        if (ResourceUtil.isSyntheticResource((Resource)parent)) {
            Resource grandParent = parent.getParent();
            if (grandParent != null) {
                this.create(grandParent, parent.getName(), null);
            } else {
                throw new IllegalArgumentException("Can't create child on a synthetic root");
            }
        }
        Resource rsrc = this.control.create(this.context, path, properties);
        rsrc.getResourceMetadata().setResolutionPath(rsrc.getPath());
        return this.factory.getResourceDecoratorTracker().decorate(rsrc);
    }

    public void revert() {
        this.control.revert(this.context);
    }

    public void commit() throws PersistenceException {
        this.control.commit(this.context);
        this.resourceTypeLookupCache.clear();
    }

    public boolean hasChanges() {
        return this.control.hasChanges(this.context);
    }

    public boolean hasChildren(Resource resource) {
        return this.listChildren(resource).hasNext();
    }

    public String getParentResourceType(Resource resource) {
        String resourceSuperType = null;
        if (resource != null && (resourceSuperType = resource.getResourceSuperType()) == null) {
            resourceSuperType = this.getParentResourceType(resource.getResourceType());
        }
        return resourceSuperType;
    }

    public String getParentResourceType(String resourceType) {
        return this.control.getParentResourceType(this.factory, this, resourceType);
    }

    public boolean isResourceType(Resource resource, String resourceType) {
        if (resource != null && resourceType != null) {
            ResourceTypeInformation key = new ResourceTypeInformation(resource.getResourceType(), resource.getResourceSuperType(), resourceType);
            Boolean value = this.resourceTypeLookupCache.computeIfAbsent(key, k -> this.isResourceTypeInternal(resource, resourceType));
            return value;
        }
        return false;
    }

    boolean isResourceTypeInternal(Resource resource, String resourceType) {
        boolean result = false;
        if (ResourceTypeUtil.areResourceTypesEqual(resourceType, resource.getResourceType(), this.factory.getSearchPath())) {
            result = true;
        } else {
            HashSet<String> superTypesChecked = new HashSet<String>();
            String superType = this.getParentResourceType(resource);
            while (!result && superType != null) {
                if (ResourceTypeUtil.areResourceTypesEqual(resourceType, superType, this.factory.getSearchPath())) {
                    result = true;
                    continue;
                }
                superTypesChecked.add(superType);
                if ((superType = this.getParentResourceType(superType)) == null || !superTypesChecked.contains(superType)) continue;
                throw new SlingException("Cyclic dependency for resourceSuperType hierarchy detected on resource " + resource.getPath(), null);
            }
        }
        return result;
    }

    public void refresh() {
        this.control.refresh(this.context);
        this.resourceTypeLookupCache.clear();
    }

    public Resource getParent(Resource child) {
        Resource rsrc = null;
        String parentPath = ResourceUtil.getParent((String)child.getPath());
        if (parentPath != null) {
            if (!parentPath.startsWith("/")) {
                rsrc = this.context.getResourceResolver().getResource(parentPath);
            } else {
                rsrc = this.control.getParent(this.context, parentPath, child);
                if (rsrc != null) {
                    rsrc.getResourceMetadata().setResolutionPath(rsrc.getPath());
                    rsrc = this.factory.getResourceDecoratorTracker().decorate(rsrc);
                }
            }
        }
        return rsrc;
    }

    public Resource copy(String srcAbsPath, String destAbsPath) throws PersistenceException {
        Resource rsrc = this.control.copy(this.context, srcAbsPath, destAbsPath);
        if (rsrc != null) {
            rsrc.getResourceMetadata().setResolutionPath(rsrc.getPath());
            rsrc = this.factory.getResourceDecoratorTracker().decorate(rsrc);
        }
        return rsrc;
    }

    public Resource move(String srcAbsPath, String destAbsPath) throws PersistenceException {
        Resource rsrc = this.control.move(this.context, srcAbsPath, destAbsPath);
        if (rsrc != null) {
            rsrc.getResourceMetadata().setResolutionPath(rsrc.getPath());
            rsrc = this.factory.getResourceDecoratorTracker().decorate(rsrc);
        }
        return rsrc;
    }

    public class ResourceTypeInformation {
        String s1;
        String s2;
        String s3;

        public ResourceTypeInformation(String resourceType, String resourceSuperType, String resourceTypeToCompareTo) {
            this.s1 = resourceType;
            this.s2 = resourceSuperType;
            this.s3 = resourceTypeToCompareTo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hash(this.s1, this.s2, this.s3);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceTypeInformation other = (ResourceTypeInformation)obj;
            return Objects.equals(this.s1, other.s1) && Objects.equals(this.s2, other.s2) && Objects.equals(this.s3, other.s3);
        }
    }
}

