/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.resourceresolver.impl.observation.BasicObserverConfiguration;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListImpl;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerInfo;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicObservationReporter
implements ObservationReporter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ObserverConfiguration> configs;
    private final String[] searchPath;

    public BasicObservationReporter(String[] searchPath, Collection<ResourceChangeListenerInfo> infos) {
        this.searchPath = searchPath;
        HashSet<String> paths = new HashSet<String>();
        ArrayList<ResourceChangeListenerInfo> result = new ArrayList<ResourceChangeListenerInfo>();
        for (ResourceChangeListenerInfo info : infos) {
            if (info.getProviderChangeTypes().isEmpty()) continue;
            for (Path p : info.getPaths()) {
                paths.add(p.getPath());
            }
            result.add(info);
        }
        BasicObserverConfiguration cfg = new BasicObserverConfiguration(PathSet.fromStringCollection(paths));
        for (ResourceChangeListenerInfo i : infos) {
            cfg.addListener(i);
        }
        this.configs = Collections.singletonList(cfg);
    }

    public BasicObservationReporter(String[] searchPath, Collection<ResourceChangeListenerInfo> infos, Path providerPath, PathSet excludePaths) {
        this.searchPath = searchPath;
        ArrayList<BasicObserverConfiguration> observerConfigs = new ArrayList<BasicObserverConfiguration>();
        for (ResourceChangeListenerInfo info : infos) {
            BasicObserverConfiguration config;
            if (info.getResourceChangeTypes().isEmpty()) continue;
            HashSet<Path> paths = new HashSet<Path>();
            for (Path p : info.getPaths()) {
                boolean add;
                boolean bl = add = providerPath.matches(p.getPath()) || !p.isPattern() && p.matches(providerPath.getPath());
                if (add) {
                    if (p.isPattern()) {
                        for (Path exclude : excludePaths) {
                            if (!p.getPath().startsWith("glob:" + exclude.getPath() + "/")) continue;
                            this.logger.debug("ResourceChangeListener {} is shadowed by {}", (Object)info, (Object)exclude);
                            add = false;
                            break;
                        }
                    } else {
                        Path path = excludePaths.matches(p.getPath());
                        if (path != null) {
                            this.logger.debug("ResourceChangeListener {} is shadowed by {}", (Object)info, (Object)path);
                            add = false;
                        }
                    }
                }
                if (!add) continue;
                paths.add(p);
            }
            if (paths.isEmpty()) continue;
            PathSet pathSet = PathSet.fromPathCollection(paths);
            BasicObserverConfiguration found = null;
            for (ObserverConfiguration observerConfiguration : observerConfigs) {
                if (!observerConfiguration.getPaths().equals((Object)pathSet) || (observerConfiguration.getPropertyNamesHint() != null || info.getPropertyNamesHint() != null) && (observerConfiguration.getPropertyNamesHint() == null || !observerConfiguration.getPropertyNamesHint().equals(info.getPropertyNamesHint()))) continue;
                found = (BasicObserverConfiguration)observerConfiguration;
                break;
            }
            if (found != null) {
                boolean bl;
                boolean bl2 = false;
                if (!found.includeExternal() && info.isExternal()) {
                    boolean bl3 = true;
                }
                if (!found.getChangeTypes().equals(info.getResourceChangeTypes())) {
                    bl = true;
                }
                if (bl) {
                    observerConfigs.remove(found);
                    HashSet<ResourceChange.ChangeType> types = new HashSet<ResourceChange.ChangeType>();
                    types.addAll(found.getChangeTypes());
                    types.addAll(info.getResourceChangeTypes());
                    config = new BasicObserverConfiguration(pathSet, types, info.isExternal() || found.includeExternal(), found.getExcludedPaths(), found.getPropertyNamesHint());
                    observerConfigs.add(config);
                    for (ResourceChangeListenerInfo i : found.getListeners()) {
                        config.addListener(i);
                    }
                } else {
                    config = found;
                }
            } else {
                config = new BasicObserverConfiguration(pathSet, info.getResourceChangeTypes(), info.isExternal(), excludePaths.getSubset(pathSet), info.getPropertyNamesHint());
                observerConfigs.add(config);
            }
            config.addListener(info);
        }
        this.configs = Collections.unmodifiableList(observerConfigs);
    }

    public List<ObserverConfiguration> getObserverConfigurations() {
        return this.configs;
    }

    public void reportChanges(Iterable<ResourceChange> changes, boolean distribute) {
        for (ObserverConfiguration cfg : this.configs) {
            List<ResourceChange> filteredChanges = this.filterChanges(changes, cfg);
            if (filteredChanges.isEmpty()) continue;
            this.reportChanges(cfg, filteredChanges, distribute);
        }
    }

    public void reportChanges(ObserverConfiguration config, Iterable<ResourceChange> changes, boolean distribute) {
        if (config != null && config instanceof BasicObserverConfiguration) {
            BasicObserverConfiguration observerConfig = (BasicObserverConfiguration)config;
            ResourceChangeListenerInfo previousInfo = null;
            List<ResourceChange> filteredChanges = null;
            for (ResourceChangeListenerInfo info : observerConfig.getListeners()) {
                ResourceChangeListener listener;
                if (previousInfo == null || !this.equals(previousInfo, info)) {
                    filteredChanges = this.filterChanges(changes, info);
                    previousInfo = info;
                }
                if (filteredChanges.isEmpty() || (listener = info.getListener()) == null) continue;
                listener.onChange(filteredChanges);
            }
            if (distribute) {
                this.logger.error("Distrubte flag is send for observation events, however distribute is currently not implemented!");
            }
        }
    }

    private boolean equals(ResourceChangeListenerInfo infoA, ResourceChangeListenerInfo infoB) {
        if (infoA.isExternal() && !infoB.isExternal()) {
            return false;
        }
        if (!infoA.isExternal() && infoB.isExternal()) {
            return false;
        }
        return infoA.getResourceChangeTypes().equals(infoB.getResourceChangeTypes()) && infoA.getProviderChangeTypes().equals(infoB.getProviderChangeTypes());
    }

    private List<ResourceChange> filterChanges(Iterable<ResourceChange> changes, ObserverConfiguration config) {
        ResourceChangeListImpl filtered = new ResourceChangeListImpl(this.searchPath);
        for (ResourceChange c : changes) {
            if (!this.matches(c, config)) continue;
            filtered.add(c);
        }
        filtered.lock();
        return filtered;
    }

    private List<ResourceChange> filterChanges(Iterable<ResourceChange> changes, ResourceChangeListenerInfo config) {
        ResourceChangeListImpl filtered = new ResourceChangeListImpl(this.searchPath);
        for (ResourceChange c : changes) {
            if (!this.matches(c, config)) continue;
            filtered.add(c);
        }
        filtered.lock();
        return filtered;
    }

    private boolean matches(ResourceChange change, ObserverConfiguration config) {
        if (!config.getChangeTypes().contains(change.getType())) {
            return false;
        }
        if (!config.includeExternal() && change.isExternal()) {
            return false;
        }
        if (config.getPaths().matches(change.getPath()) == null) {
            return false;
        }
        return config.getExcludedPaths().matches(change.getPath()) == null;
    }

    private boolean matches(ResourceChange change, ResourceChangeListenerInfo config) {
        if (!config.getResourceChangeTypes().contains(change.getType()) && !config.getProviderChangeTypes().contains(change.getType())) {
            return false;
        }
        return config.isExternal() || !change.isExternal();
    }
}

