/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryPreconditions {
    private volatile ResourceProviderTracker tracker;
    private volatile List<RequiredProvider> requiredProviders;

    public void activate(BundleContext bc, String[] configuration, ResourceProviderTracker tracker) {
        this.tracker = tracker;
        ArrayList<RequiredProvider> rps = new ArrayList<RequiredProvider>();
        if (configuration != null) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            for (String r : configuration) {
                if (r == null || r.trim().length() <= 0) continue;
                String value = r.trim();
                RequiredProvider rp = new RequiredProvider();
                if (value.startsWith("(")) {
                    try {
                        rp.filter = bc.createFilter(value);
                    }
                    catch (InvalidSyntaxException e) {
                        logger.warn("Ignoring invalid filter syntax for required provider: " + value, (Throwable)e);
                        rp = null;
                    }
                } else {
                    rp.pid = value;
                }
                if (rp == null) continue;
                rps.add(rp);
            }
        }
        this.requiredProviders = rps;
    }

    public void deactivate() {
        this.requiredProviders = null;
        this.tracker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPreconditions(String unavailableServicePid) {
        FactoryPreconditions factoryPreconditions = this;
        synchronized (factoryPreconditions) {
            boolean canRegister;
            List<RequiredProvider> localRequiredProviders = this.requiredProviders;
            ResourceProviderTracker localTracker = this.tracker;
            boolean bl = canRegister = localTracker != null;
            if (localRequiredProviders != null && localTracker != null) {
                for (RequiredProvider rp : localRequiredProviders) {
                    canRegister = false;
                    for (ResourceProviderHandler h : localTracker.getResourceProviderStorage().getAllHandlers()) {
                        ServiceReference ref = h.getInfo().getServiceReference();
                        String servicePid = (String)ref.getProperty("service.pid");
                        if (unavailableServicePid != null && unavailableServicePid.equals(servicePid)) continue;
                        if (rp.filter != null && rp.filter.match(ref)) {
                            canRegister = true;
                            break;
                        }
                        if (rp.pid != null && rp.pid.equals(servicePid)) {
                            canRegister = true;
                            break;
                        }
                        if (rp.pid == null || !rp.pid.equals(ref.getProperty("original.service.pid"))) continue;
                        canRegister = true;
                        break;
                    }
                    if (canRegister) continue;
                    break;
                }
            }
            return canRegister;
        }
    }

    private static final class RequiredProvider {
        public String pid;
        public Filter filter;

        private RequiredProvider() {
        }
    }
}

