/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.resourcemerger.impl.MergedResource;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker2;

public class CRUDMergedResource
extends MergedResource {
    private final MergedResourcePicker2 picker;
    private final String relativePath;

    CRUDMergedResource(ResourceResolver resolver, String mergeRootPath, String relativePath, List<Resource> mappedResources, List<ValueMap> valueMaps, MergedResourcePicker2 picker) {
        super(resolver, mergeRootPath, relativePath, mappedResources, valueMaps);
        this.picker = picker;
        this.relativePath = relativePath;
    }

    @Override
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ModifiableValueMap.class) {
            Iterator<Resource> iter = this.picker.pickResources(this.getResourceResolver(), this.relativePath, null).iterator();
            Resource highestRsrc = null;
            while (iter.hasNext()) {
                highestRsrc = iter.next();
            }
            if (ResourceUtil.isNonExistingResource(highestRsrc)) {
                String[] paths = (String[])this.getResourceMetadata().get((Object)"sling.mergedResources");
                Resource copyResource = this.getResourceResolver().getResource(paths[paths.length - 1]);
                try {
                    Resource newResource = ResourceUtil.getOrCreateResource((ResourceResolver)this.getResourceResolver(), (String)highestRsrc.getPath(), (String)copyResource.getResourceType(), null, (boolean)false);
                    ModifiableValueMap target = (ModifiableValueMap)newResource.adaptTo(ModifiableValueMap.class);
                    if (target != null) {
                        return (AdapterType)new ModifiableProperties((Resource)this, target);
                    }
                }
                catch (PersistenceException pe) {
                    // empty catch block
                }
                return super.adaptTo(type);
            }
            ModifiableValueMap target = (ModifiableValueMap)highestRsrc.adaptTo(ModifiableValueMap.class);
            if (target != null) {
                return (AdapterType)new ModifiableProperties((Resource)this, target);
            }
        }
        return super.adaptTo(type);
    }

    private static final class ModifiableProperties
    implements ModifiableValueMap {
        private final ModifiableValueMap targetMap;
        private final ValueMap properties;

        public ModifiableProperties(Resource rsrc, ModifiableValueMap targetMap) {
            this.properties = new DeepReadValueMapDecorator(rsrc, (ValueMap)new ValueMapDecorator(new HashMap(rsrc.getValueMap())));
            this.targetMap = targetMap;
        }

        public <T> T get(String name, Class<T> type) {
            return (T)this.properties.get(name, type);
        }

        public <T> T get(String name, T defaultValue) {
            return (T)this.properties.get(name, defaultValue);
        }

        public int size() {
            return this.properties.size();
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.properties.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.properties.containsValue(value);
        }

        public Object get(Object key) {
            return this.properties.get(key);
        }

        public Object put(String key, Object value) {
            Object result = this.properties.get((Object)key);
            this.targetMap.put((Object)key, value);
            return result;
        }

        public Object remove(Object key) {
            Object result = this.properties.get(key);
            if (this.targetMap.remove(key) == null) {
                String[] newHiddenProps;
                String[] hiddenProps = (String[])this.targetMap.get("sling:hideProperties", String[].class);
                if (hiddenProps == null || hiddenProps.length == 0) {
                    newHiddenProps = new String[]{key.toString()};
                } else {
                    newHiddenProps = new String[hiddenProps.length + 1];
                    System.arraycopy(hiddenProps, 0, newHiddenProps, 0, hiddenProps.length);
                    newHiddenProps[hiddenProps.length] = key.toString();
                }
                this.targetMap.put((Object)"sling:hideProperties", (Object)newHiddenProps);
            }
            return result;
        }

        public void putAll(Map<? extends String, ? extends Object> m) {
            if (m != null) {
                for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }

        public void clear() {
        }

        public Set<String> keySet() {
            return this.properties.keySet();
        }

        public Collection<Object> values() {
            return this.properties.values();
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.properties.entrySet();
        }
    }
}

