/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl.picker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourcemerger.api.ResourceMergerService;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.resourcemerger.impl.MergedResourceProviderFactory", label="Apache Sling Merged Resource Provider Factory", description="This resource provider delivers merged resources based on the search paths.", metatype=true)
@Service(value={MergedResourcePicker.class, ResourceMergerService.class})
@Properties(value={@Property(name="merge.root", value={"/mnt/overlay"}, label="Root", description="The mount point of merged resources"), @Property(name="merge.readOnly", boolValue={true}, label="Read Only", description="Specifies if the resources are read-only or can be modified.")})
public class MergingResourcePicker
implements MergedResourcePicker,
ResourceMergerService {
    public static final String DEFAULT_ROOT = "/mnt/overlay";
    private String mergeRootPath;

    @Override
    public List<Resource> pickResources(ResourceResolver resolver, String relativePath) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String[] searchPaths = resolver.getSearchPath();
        for (int i = searchPaths.length - 1; i >= 0; --i) {
            String basePath = searchPaths[i];
            String fullPath = basePath + relativePath;
            Resource resource = resolver.getResource(fullPath);
            if (resource != null) {
                resources.add(resource);
                continue;
            }
            resources.add((Resource)new NonExistingResource(resolver, fullPath));
        }
        return resources;
    }

    @Override
    public String getMergedResourcePath(String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException("Provided relative path is null");
        }
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Provided path is not a relative path");
        }
        return this.mergeRootPath + "/" + relativePath;
    }

    @Override
    public Resource getMergedResource(Resource resource) {
        if (resource != null) {
            String[] searchPaths;
            ResourceResolver resolver = resource.getResourceResolver();
            for (String searchPathPrefix : searchPaths = resolver.getSearchPath()) {
                if (!resource.getPath().startsWith(searchPathPrefix)) continue;
                String searchPath = searchPathPrefix.substring(0, searchPathPrefix.length() - 1);
                return resolver.getResource(resource.getPath().replaceFirst(searchPath, this.mergeRootPath));
            }
        }
        return null;
    }

    @Override
    public boolean isMergedResource(Resource resource) {
        if (resource == null) {
            return false;
        }
        return Boolean.TRUE.equals(resource.getResourceMetadata().get((Object)"sling.mergedResource"));
    }

    @Override
    public String getResourcePath(String searchPath, String mergedResourcePath) {
        if (searchPath == null || !searchPath.startsWith("/") || !searchPath.endsWith("/")) {
            throw new IllegalArgumentException("Provided path is not a valid search path: " + searchPath);
        }
        if (mergedResourcePath == null || !mergedResourcePath.startsWith(this.mergeRootPath + "/")) {
            throw new IllegalArgumentException("Provided path does not point to a merged resource: " + mergedResourcePath);
        }
        return searchPath + mergedResourcePath.substring(this.mergeRootPath.length() + 1);
    }

    @Activate
    protected void configure(Map<String, Object> properties) {
        this.mergeRootPath = PropertiesUtil.toString((Object)properties.get("provider.roots"), (String)DEFAULT_ROOT);
    }
}

