/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resourcemerger.impl.MergedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedResourceProvider
implements ResourceProvider {
    private final String mergeRootPath;

    public MergedResourceProvider(String mergeRootPath) {
        this.mergeRootPath = mergeRootPath;
    }

    public Resource getResource(ResourceResolver resolver, HttpServletRequest request, String path) {
        return this.getResource(resolver, path);
    }

    public Resource getResource(ResourceResolver resolver, String path) {
        String relativePath = this.getRelativePath(path);
        if (relativePath != null) {
            ResourceHolder holder = new ResourceHolder(ResourceUtil.getName((String)path));
            String[] searchPaths = resolver.getSearchPath();
            for (int i = searchPaths.length - 1; i >= 0; --i) {
                String basePath = searchPaths[i];
                String fullPath = basePath + relativePath;
                Resource parent = resolver.getResource(ResourceUtil.getParent((String)fullPath));
                if (parent == null) continue;
                boolean hidden = new ParentHidingHandler(parent).isHidden(holder.name);
                if (hidden) {
                    holder.resources.clear();
                    continue;
                }
                Resource baseRes = resolver.getResource(fullPath);
                if (baseRes == null) continue;
                holder.resources.add(baseRes);
            }
            return this.createMergedResource(resolver, relativePath, holder);
        }
        return null;
    }

    private Resource createMergedResource(ResourceResolver resolver, String relativePath, ResourceHolder holder) {
        int index = 0;
        while (index < holder.resources.size()) {
            Resource baseRes = holder.resources.get(index);
            ValueMap props = ResourceUtil.getValueMap((Resource)baseRes);
            holder.valueMaps.add(props);
            if (((Boolean)props.get("sling:hideResource", (Object)Boolean.FALSE)).booleanValue()) {
                for (int i = 0; i <= index; ++i) {
                    holder.resources.remove(0);
                }
                holder.valueMaps.clear();
                index = 0;
                continue;
            }
            ++index;
        }
        if (!holder.resources.isEmpty()) {
            return new MergedResource(resolver, this.mergeRootPath, relativePath, holder.resources, holder.valueMaps);
        }
        return null;
    }

    public Iterator<Resource> listChildren(Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        String relativePath = this.getRelativePath(resource.getPath());
        if (relativePath != null) {
            ArrayList<ResourceHolder> candidates = new ArrayList<ResourceHolder>();
            String[] searchPaths = resolver.getSearchPath();
            for (int i = searchPaths.length - 1; i >= 0; --i) {
                String basePath = searchPaths[i];
                Resource parentResource = resolver.getResource(basePath + relativePath);
                if (parentResource == null) continue;
                ParentHidingHandler handler = new ParentHidingHandler(parentResource);
                for (Resource child : parentResource.getChildren()) {
                    String rsrcName = child.getName();
                    ResourceHolder holder = null;
                    for (ResourceHolder current : candidates) {
                        if (!current.name.equals(rsrcName)) continue;
                        holder = current;
                        break;
                    }
                    if (holder == null) {
                        holder = new ResourceHolder(rsrcName);
                        candidates.add(holder);
                    }
                    holder.resources.add(child);
                    int orderBeforeIndex = -1;
                    ValueMap vm = ResourceUtil.getValueMap((Resource)child);
                    String orderBefore = (String)vm.get("sling:orderBefore", String.class);
                    if (orderBefore != null && !orderBefore.equals(rsrcName)) {
                        for (int index = 0; index < candidates.size(); ++index) {
                            ResourceHolder current = (ResourceHolder)candidates.get(index);
                            if (!current.name.equals(orderBefore)) continue;
                            orderBeforeIndex = index;
                            break;
                        }
                    }
                    if (orderBeforeIndex <= -1) continue;
                    candidates.add(orderBeforeIndex, holder);
                    candidates.remove(candidates.size() - 1);
                }
                Iterator iter = candidates.iterator();
                while (iter.hasNext()) {
                    ResourceHolder holder = (ResourceHolder)iter.next();
                    if (!handler.isHidden(holder.name)) continue;
                    iter.remove();
                }
            }
            ArrayList<Resource> children = new ArrayList<Resource>();
            for (ResourceHolder holder : candidates) {
                Resource mergedResource = this.createMergedResource(resolver, relativePath.length() == 0 ? holder.name : relativePath + '/' + holder.name, holder);
                if (mergedResource == null) continue;
                children.add(mergedResource);
            }
            return children.iterator();
        }
        return null;
    }

    private String getRelativePath(String path) {
        if (path.startsWith(this.mergeRootPath)) {
            if ((path = path.substring(this.mergeRootPath.length())).length() == 0) {
                return path;
            }
            if (path.charAt(0) == '/') {
                return path.substring(1);
            }
        }
        return null;
    }

    private static final class ResourceHolder {
        public final String name;
        public final List<Resource> resources = new ArrayList<Resource>();
        public final List<ValueMap> valueMaps = new ArrayList<ValueMap>();

        public ResourceHolder(String n) {
            this.name = n;
        }
    }

    private static final class ParentHidingHandler {
        private final String[] childrenToHideArray;

        public ParentHidingHandler(Resource parent) {
            ValueMap parentProps = ResourceUtil.getValueMap((Resource)parent);
            this.childrenToHideArray = (String[])parentProps.get("sling:hideChildren", String[].class);
        }

        public boolean isHidden(String name) {
            boolean hidden = false;
            if (this.childrenToHideArray != null) {
                for (String entry : this.childrenToHideArray) {
                    if (!entry.equals("*") && !entry.equals(name)) continue;
                    hidden = true;
                    break;
                }
            }
            return hidden;
        }
    }
}

