/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.spi.ImplementationPicker;

@Component
@Service
@Property(name="service.ranking", intValue={0x7FFFFFFE})
public class ResourceTypeBasedResourcePicker
implements ImplementationPicker {
    public Class<?> pick(@Nonnull Class<?> adapterType, @Nonnull Class<?>[] implementationsTypes, @Nonnull Object adaptable) {
        Resource resource = this.findResource(adaptable);
        if (resource == null) {
            return null;
        }
        Map<String, Class<?>> implementationsByRT = this.mapByResourceType(implementationsTypes);
        return AdapterImplementations.getModelClassForResource(resource, implementationsByRT);
    }

    private Resource findResource(Object adaptable) {
        if (adaptable instanceof Resource) {
            return (Resource)adaptable;
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)adaptable).getResource();
        }
        return null;
    }

    private Map<String, Class<?>> mapByResourceType(Class<?>[] implementationTypes) {
        HashMap retval = new HashMap(implementationTypes.length);
        for (Class<?> clazz : implementationTypes) {
            String[] resourceTypes;
            Model modelAnnotation = clazz.getAnnotation(Model.class);
            if (modelAnnotation == null) continue;
            for (String resourceType : resourceTypes = modelAnnotation.resourceType()) {
                if (retval.containsKey(resourceType)) continue;
                retval.put(resourceType, clazz);
            }
        }
        return retval;
    }
}

