/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.models.spi.ViaProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceTypeViaProvider
implements ViaProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public Object getAdaptable(Object original, String value) {
        if (!this.handle(value)) {
            return ORIGINAL;
        }
        if (original instanceof Resource) {
            Resource resource = (Resource)original;
            String resourceType = this.getResourceType(resource, value);
            if (resourceType == null) {
                this.log.warn("Could not determine forced resource type for {} using via value {}.", (Object)resource, (Object)value);
                return null;
            }
            return new ResourceTypeForcingResourceWrapper(resource, resourceType);
        }
        if (original instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)original;
            Resource resource = request.getResource();
            if (resource == null) {
                return null;
            }
            String resourceType = this.getResourceType(resource, value);
            if (resourceType == null) {
                this.log.warn("Could not determine forced resource type for {} using via value {}.", (Object)resource, (Object)value);
                return null;
            }
            return new ResourceTypeForcingRequestWrapper(request, resource, resourceType);
        }
        this.log.warn("Received unexpected adaptable of type {}.", (Object)original.getClass().getName());
        return null;
    }

    protected abstract boolean handle(@NotNull String var1);

    @Nullable
    protected abstract String getResourceType(@NotNull Resource var1, @NotNull String var2);

    private class ResourceTypeForcingRequestWrapper
    extends SlingHttpServletRequestWrapper {
        private final Resource resource;

        private ResourceTypeForcingRequestWrapper(SlingHttpServletRequest request, Resource resource, String resourceType) {
            super(request);
            this.resource = new ResourceTypeForcingResourceWrapper(resource, resourceType);
        }

        public Resource getResource() {
            return this.resource;
        }
    }

    private class ResourceTypeForcingResourceWrapper
    extends ResourceWrapper {
        private final String resourceType;

        private ResourceTypeForcingResourceWrapper(Resource resource, String resourceType) {
            super(resource);
            this.resourceType = resourceType;
        }

        public String getResourceType() {
            return this.resourceType;
        }
    }
}

