/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.model.InjectableField;
import org.apache.sling.models.impl.model.InjectableMethod;
import org.apache.sling.models.impl.model.ModelClassConstructor;
import org.apache.sling.models.impl.model.ParameterCountInjectComparator;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class ModelClass<ModelType> {
    private final Class<ModelType> type;
    private final Model modelAnnotation;
    final DefaultInjectionStrategy defaultInjectionStrategy;
    private volatile ModelClassConstructor<?>[] constructors;
    private volatile InjectableField[] injectableFields;
    private volatile InjectableMethod[] injectableMethods;

    public ModelClass(Class<ModelType> type, StaticInjectAnnotationProcessorFactory[] processorFactories) {
        this.type = type;
        this.modelAnnotation = type.getAnnotation(Model.class);
        this.defaultInjectionStrategy = this.modelAnnotation == null ? DefaultInjectionStrategy.REQUIRED : this.modelAnnotation.defaultInjectionStrategy();
        this.updateProcessorFactories(processorFactories);
    }

    public void updateProcessorFactories(StaticInjectAnnotationProcessorFactory[] processorFactories) {
        this.constructors = ModelClass.getConstructors(this.type, processorFactories, this.defaultInjectionStrategy);
        this.injectableFields = ModelClass.getInjectableFields(this.type, processorFactories, this.defaultInjectionStrategy);
        this.injectableMethods = ModelClass.getInjectableMethods(this.type, processorFactories, this.defaultInjectionStrategy);
    }

    private static ModelClassConstructor<?>[] getConstructors(Class<?> type, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        if (type.isInterface()) {
            return new ModelClassConstructor[0];
        }
        Constructor<?>[] constructors = type.getConstructors();
        Arrays.sort(constructors, new ParameterCountInjectComparator());
        ModelClassConstructor[] array = new ModelClassConstructor[constructors.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new ModelClassConstructor(constructors[i], processorFactories, defaultInjectionStrategy);
        }
        return array;
    }

    private static InjectableField[] getInjectableFields(Class<?> type, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        if (type.isInterface()) {
            return new InjectableField[0];
        }
        List<Field> injectableFields = ReflectionUtil.collectInjectableFields(type);
        InjectableField[] array = new InjectableField[injectableFields.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new InjectableField(injectableFields.get(i), processorFactories, defaultInjectionStrategy);
        }
        return array;
    }

    private static InjectableMethod[] getInjectableMethods(Class<?> type, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        if (!type.isInterface()) {
            return new InjectableMethod[0];
        }
        List<Method> injectableMethods = ReflectionUtil.collectInjectableMethods(type);
        InjectableMethod[] array = new InjectableMethod[injectableMethods.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new InjectableMethod(injectableMethods.get(i), processorFactories, defaultInjectionStrategy);
        }
        return array;
    }

    public Class<ModelType> getType() {
        return this.type;
    }

    public Model getModelAnnotation() {
        return this.modelAnnotation;
    }

    public boolean hasModelAnnotation() {
        return this.modelAnnotation != null;
    }

    public ModelClassConstructor[] getConstructors() {
        return this.constructors;
    }

    public InjectableField[] getInjectableFields() {
        return this.injectableFields;
    }

    public InjectableMethod[] getInjectableMethods() {
        return this.injectableMethods;
    }
}

