/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.model;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.ReflectionUtil;
import org.apache.sling.models.impl.Result;
import org.apache.sling.models.impl.model.AbstractInjectableElement;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;

public class InjectableField
extends AbstractInjectableElement {
    private final Field field;

    public InjectableField(Field field, StaticInjectAnnotationProcessorFactory[] processorFactories, DefaultInjectionStrategy defaultInjectionStrategy) {
        super(field, ReflectionUtil.mapPrimitiveClasses(field.getGenericType()), field.getName(), processorFactories, defaultInjectionStrategy);
        this.field = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeException set(Object createdObject, Result<Object> result) {
        Field field = this.field;
        synchronized (field) {
            boolean accessible = this.field.isAccessible();
            try {
                if (!accessible) {
                    this.field.setAccessible(true);
                }
                this.field.set(createdObject, result.getValue());
                if (!accessible) {
                    this.field.setAccessible(false);
                }
            }
            catch (Exception e) {
                ModelClassException modelClassException;
                block13: {
                    try {
                        modelClassException = new ModelClassException("Could not inject field due to reflection issues", (Throwable)e);
                        if (accessible) break block13;
                        this.field.setAccessible(false);
                    }
                    catch (Throwable throwable) {
                        if (!accessible) {
                            this.field.setAccessible(false);
                        }
                        throw throwable;
                    }
                }
                return modelClassException;
            }
            return null;
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Type getFieldGenericType() {
        return this.field.getGenericType();
    }
}

