/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.spi.AcceptsNullName;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.apache.sling.models.spi.injectorspecific.AbstractInjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessor2;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.ranking:Integer=2147483647"}, service={Injector.class, StaticInjectAnnotationProcessorFactory.class, AcceptsNullName.class})
public final class SlingObjectInjector
implements Injector,
StaticInjectAnnotationProcessorFactory,
AcceptsNullName {
    @NotNull
    public static final String NAME = "sling-object";

    @NotNull
    public String getName() {
        return NAME;
    }

    public Object getValue(@NotNull Object adaptable, String name, @NotNull Type type, @NotNull AnnotatedElement element, @NotNull DisposalCallbackRegistry callbackRegistry) {
        if (!(type instanceof Class)) {
            return null;
        }
        Class requestedClass = (Class)type;
        if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest request = (SlingHttpServletRequest)adaptable;
            if (requestedClass.equals(ResourceResolver.class)) {
                return request.getResourceResolver();
            }
            if (requestedClass.equals(Resource.class) && element.isAnnotationPresent(SlingObject.class)) {
                return request.getResource();
            }
            if (requestedClass.equals(SlingHttpServletRequest.class) || requestedClass.equals(HttpServletRequest.class)) {
                return request;
            }
            if (requestedClass.equals(SlingHttpServletResponse.class) || requestedClass.equals(HttpServletResponse.class)) {
                return this.getSlingHttpServletResponse(request);
            }
            if (requestedClass.equals(SlingScriptHelper.class)) {
                return this.getSlingScriptHelper(request);
            }
        } else if (adaptable instanceof ResourceResolver) {
            ResourceResolver resourceResolver = (ResourceResolver)adaptable;
            if (requestedClass.equals(ResourceResolver.class)) {
                return resourceResolver;
            }
        } else if (adaptable instanceof Resource) {
            Resource resource = (Resource)adaptable;
            if (requestedClass.equals(ResourceResolver.class)) {
                return resource.getResourceResolver();
            }
            if (requestedClass.equals(Resource.class) && element.isAnnotationPresent(SlingObject.class)) {
                return resource;
            }
        }
        return null;
    }

    private SlingScriptHelper getSlingScriptHelper(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        if (bindings != null) {
            return bindings.getSling();
        }
        return null;
    }

    private SlingHttpServletResponse getSlingHttpServletResponse(SlingHttpServletRequest request) {
        SlingScriptHelper scriptHelper = this.getSlingScriptHelper(request);
        if (scriptHelper != null) {
            return scriptHelper.getResponse();
        }
        return null;
    }

    public InjectAnnotationProcessor2 createAnnotationProcessor(AnnotatedElement element) {
        SlingObject annotation = element.getAnnotation(SlingObject.class);
        if (annotation != null) {
            return new SlingObjectAnnotationProcessor(annotation);
        }
        return null;
    }

    private static class SlingObjectAnnotationProcessor
    extends AbstractInjectAnnotationProcessor2 {
        private final SlingObject annotation;

        public SlingObjectAnnotationProcessor(SlingObject annotation) {
            this.annotation = annotation;
        }

        public InjectionStrategy getInjectionStrategy() {
            return this.annotation.injectionStrategy();
        }

        public Boolean isOptional() {
            return this.annotation.optional();
        }
    }
}

