/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.shared;

import java.beans.Introspector;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.jar.JarFile;
import org.apache.sling.commons.osgi.bundleversion.BundleVersionInfo;
import org.apache.sling.commons.osgi.bundleversion.FileBundleVersionInfo;
import org.apache.sling.launchpad.base.shared.LauncherClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Loader {
    private final File slingHome;

    public Loader(String slingHome) throws IllegalArgumentException {
        this.slingHome = Loader.getSlingHomeFile((String)slingHome);
        this.removeOldLauncherJars();
    }

    public Object loadLauncher(String launcherClassName) {
        LauncherClassLoader loader;
        File launcherJarFile = this.getLauncherJarFile();
        this.info("Loading launcher class " + launcherClassName + " from " + launcherJarFile.getName());
        if (!launcherJarFile.canRead()) {
            throw new IllegalArgumentException("Sling Launcher JAR " + launcherJarFile + " is not accessible");
        }
        try {
            loader = new LauncherClassLoader(launcherJarFile);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot create an URL from the Sling Launcher JAR path name", e);
        }
        try {
            Class<?> launcherClass = loader.loadClass(launcherClassName);
            return launcherClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Cannot find class " + launcherClassName + " in " + launcherJarFile, cnfe);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate launcher class " + launcherClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access constructor of class " + launcherClassName, e);
        }
    }

    public void cleanupVM() {
        Introspector.flushCaches();
        Loader.closeLauncherJarFile((File)this.getLauncherJarFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installLauncherJar(URL launcherJar) throws IOException {
        File currentLauncherJarFile = this.getLauncherJarFile();
        URLConnection launcherJarConn = launcherJar.openConnection();
        launcherJarConn.setUseCaches(false);
        File tmp = new File(this.slingHome, "Loader_tmp_" + System.currentTimeMillis() + "org.apache.sling.launchpad.base.jar");
        Loader.spool((InputStream)launcherJarConn.getInputStream(), (File)tmp);
        FileBundleVersionInfo newVi = new FileBundleVersionInfo(tmp);
        boolean installNewLauncher = true;
        try {
            if (!newVi.isBundle()) {
                throw new IllegalArgumentException("New launcher jar is not a bundle, cannot get version info:" + launcherJar);
            }
            if (currentLauncherJarFile.exists()) {
                FileBundleVersionInfo currentVi = new FileBundleVersionInfo(currentLauncherJarFile);
                if (!currentVi.isBundle()) {
                    throw new IllegalArgumentException("Existing launcher jar is not a bundle, cannot get version info:" + currentLauncherJarFile.getAbsolutePath());
                }
                String info = null;
                if (currentVi.compareTo((BundleVersionInfo)newVi) == 0) {
                    info = "up to date";
                    installNewLauncher = false;
                } else if (currentVi.compareTo((BundleVersionInfo)newVi) > 0) {
                    info = "more recent than ours";
                    installNewLauncher = false;
                }
                if (info != null) {
                    this.info("Existing launcher is " + info + ", using it: " + Loader.getBundleInfo((BundleVersionInfo)currentVi) + " (" + currentLauncherJarFile.getName() + ")");
                }
            }
            if (installNewLauncher) {
                File f = new File(tmp.getParentFile(), "org.apache.sling.launchpad.base.jar." + System.currentTimeMillis());
                if (!tmp.renameTo(f)) {
                    throw new IllegalStateException("Failed to rename " + tmp.getName() + " to " + f.getName());
                }
                this.info("Installing new launcher: " + launcherJar + ", " + Loader.getBundleInfo((BundleVersionInfo)newVi) + " (" + f.getName() + ")");
            }
        }
        finally {
            if (tmp.exists()) {
                tmp.delete();
            }
        }
        return installNewLauncher;
    }

    static String getBundleInfo(BundleVersionInfo<?> v) {
        StringBuilder sb = new StringBuilder();
        sb.append(v.getVersion());
        if (v.isSnapshot()) {
            sb.append(", Last-Modified:");
            sb.append(new Date(v.getBundleLastModified()));
        }
        return sb.toString();
    }

    private void removeOldLauncherJars() {
        File[] launcherJars = this.getLauncherJarFiles();
        if (launcherJars != null && launcherJars.length > 0) {
            File current = this.getLauncherJarFile();
            for (File f : launcherJars) {
                if (f.getAbsolutePath().equals(current.getAbsolutePath())) continue;
                String versionInfo = null;
                try {
                    FileBundleVersionInfo vi = new FileBundleVersionInfo(f);
                    versionInfo = Loader.getBundleInfo((BundleVersionInfo)vi);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                this.info("Deleting obsolete launcher jar: " + f.getName() + ", " + versionInfo);
                f.delete();
            }
            if (!"org.apache.sling.launchpad.base.jar".equals(current.getName())) {
                this.info("Renaming current launcher jar " + current.getName() + " to " + "org.apache.sling.launchpad.base.jar");
                File launcherFileName = new File(current.getParentFile(), "org.apache.sling.launchpad.base.jar");
                current.renameTo(launcherFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spool(InputStream ins, File destFile) throws IOException {
        FileOutputStream out = null;
        try {
            int rd;
            out = new FileOutputStream(destFile);
            byte[] buf = new byte[8192];
            while ((rd = ins.read(buf)) >= 0) {
                ((OutputStream)out).write(buf, 0, rd);
            }
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ignore) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File getLauncherJarFile() {
        File result = null;
        File[] launcherJars = this.getLauncherJarFiles();
        result = launcherJars == null || launcherJars.length == 0 ? new File(this.slingHome, "org.apache.sling.launchpad.base.jar") : launcherJars[launcherJars.length - 1];
        return result;
    }

    private File[] getLauncherJarFiles() {
        File[] rawList = this.slingHome.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<FileBundleVersionInfo> list = new ArrayList<FileBundleVersionInfo>();
        for (File f : rawList) {
            FileBundleVersionInfo fvi = null;
            try {
                fvi = new FileBundleVersionInfo(f);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Cannot read bundle information from loader file " + f.getAbsolutePath());
            }
            if (!fvi.isBundle()) continue;
            list.add(fvi);
        }
        Collections.sort(list);
        File[] result = new File[list.size()];
        int i = 0;
        for (FileBundleVersionInfo fvi : list) {
            result[i++] = fvi.getSource();
        }
        return result;
    }

    private static File getSlingHomeFile(String slingHome) {
        File slingDir;
        if (slingHome == null) {
            slingHome = "sling";
        }
        if ((slingDir = new File(slingHome).getAbsoluteFile()).exists()) {
            if (!slingDir.isDirectory()) {
                throw new IllegalArgumentException("Sling Home " + slingDir + " exists but is not a directory");
            }
        } else if (!slingDir.mkdirs()) {
            throw new IllegalArgumentException("Sling Home " + slingDir + " cannot be created as a directory");
        }
        return slingDir;
    }

    private static void closeLauncherJarFile(File launcherJar) {
        try {
            URI launcherJarUri = launcherJar.toURI();
            URL launcherJarRoot = new URL("jar:" + launcherJarUri + "!/");
            URLConnection conn = launcherJarRoot.openConnection();
            if (conn instanceof JarURLConnection) {
                JarFile jarFile = ((JarURLConnection)conn).getJarFile();
                jarFile.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void info(String msg) {
    }
}

