/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.testrunner;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONTokener;
import org.apache.sling.junit.remote.httpclient.RemoteTestHttpClient;
import org.apache.sling.junit.remote.testrunner.SlingRemoteTest;
import org.apache.sling.junit.remote.testrunner.SlingRemoteTestParameters;
import org.apache.sling.junit.remote.testrunner.SlingTestsCountChecker;
import org.apache.sling.testing.tools.http.RequestCustomizer;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingRemoteTestRunner
extends ParentRunner<SlingRemoteTest> {
    private static final Logger log = LoggerFactory.getLogger(SlingRemoteTestRunner.class);
    private final SlingRemoteTestParameters testParameters;
    private RemoteTestHttpClient testHttpClient;
    private final String username;
    private final String password;
    private final Class<?> testClass;
    private final List<SlingRemoteTest> children = new LinkedList<SlingRemoteTest>();

    public SlingRemoteTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        Object o = null;
        try {
            o = testClass.newInstance();
            if (!(o instanceof SlingRemoteTestParameters)) {
                throw new IllegalArgumentException(o.getClass().getName() + " is not a " + SlingRemoteTestParameters.class.getSimpleName());
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
        String configuredUsername = System.getProperty("test.server.username");
        this.username = configuredUsername != null && configuredUsername.trim().length() > 0 ? configuredUsername : "admin";
        String configuredPassword = System.getProperty("test.server.password");
        this.password = configuredPassword != null && configuredPassword.trim().length() > 0 ? configuredPassword : "admin";
        this.testParameters = (SlingRemoteTestParameters)o;
    }

    private void maybeExecuteTests() throws Exception {
        if (this.testHttpClient != null) {
            return;
        }
        this.testHttpClient = new RemoteTestHttpClient(this.testParameters.getJunitServletUrl(), this.username, this.password, true);
        if (this.testParameters instanceof RequestCustomizer) {
            this.testHttpClient.setRequestCustomizer((RequestCustomizer)this.testParameters);
        }
        RequestExecutor executor = this.testHttpClient.runTests(this.testParameters.getTestClassesSelector(), this.testParameters.getTestMethodSelector(), "json");
        executor.assertContentType("application/json");
        JSONArray json = new JSONArray(new JSONTokener(executor.getContent()));
        for (int i = 0; i < json.length(); ++i) {
            JSONObject obj = json.getJSONObject(i);
            if (!"test".equals(obj.getString("INFO_TYPE"))) continue;
            this.children.add(new SlingRemoteTest(this.testClass, obj));
        }
        log.info("Server-side tests executed as {} at {} with path {}", new Object[]{this.username, this.testParameters.getJunitServletUrl(), this.testHttpClient.getTestExecutionPath()});
        if (this.testParameters instanceof SlingTestsCountChecker) {
            ((SlingTestsCountChecker)((Object)this.testParameters)).checkNumberOfTests(this.children.size());
        }
    }

    protected Description describeChild(SlingRemoteTest t) {
        return t.describe();
    }

    protected List<SlingRemoteTest> getChildren() {
        try {
            this.maybeExecuteTests();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(SlingRemoteTest t, RunNotifier notifier) {
        try {
            this.maybeExecuteTests();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, t.describe());
        eachNotifier.fireTestStarted();
        try {
            log.debug("Running test {}", (Object)t.describe());
            t.run();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }
}

