/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.api.resource.external.URIProvider;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.HelperData;
import org.apache.sling.jcr.resource.internal.helper.jcr.JcrProviderState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrProviderStateFactory {
    private final Logger logger = LoggerFactory.getLogger(JcrProviderStateFactory.class);
    private final ServiceReference<SlingRepository> repositoryReference;
    private final SlingRepository repository;
    private final AtomicReference<DynamicClassLoaderManager> dynamicClassLoaderManagerReference;
    private final AtomicReference<URIProvider[]> uriProviderReference;

    public JcrProviderStateFactory(ServiceReference<SlingRepository> repositoryReference, SlingRepository repository, AtomicReference<DynamicClassLoaderManager> dynamicClassLoaderManagerReference, AtomicReference<URIProvider[]> uriProviderReference) {
        this.repository = repository;
        this.repositoryReference = repositoryReference;
        this.dynamicClassLoaderManagerReference = dynamicClassLoaderManagerReference;
        this.uriProviderReference = uriProviderReference;
    }

    @CheckForNull
    private Bundle extractCallingBundle(@Nonnull Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        Object obj = authenticationInfo.get("sling.service.bundle");
        if (obj != null && !(obj instanceof Bundle)) {
            throw new org.apache.sling.api.resource.LoginException("Invalid calling bundle object in authentication info");
        }
        return (Bundle)obj;
    }

    JcrProviderState createProviderState(@Nonnull Map<String, Object> authenticationInfo) throws org.apache.sling.api.resource.LoginException {
        BundleContext bc;
        Session session;
        block11: {
            boolean isLoginAdministrative = Boolean.TRUE.equals(authenticationInfo.get("provider.auth.admin"));
            session = JcrProviderStateFactory.getSession(authenticationInfo);
            if (session != null && !isLoginAdministrative) {
                return this.createJcrProviderState(session, false, authenticationInfo, null);
            }
            bc = null;
            try {
                Bundle bundle = this.extractCallingBundle(authenticationInfo);
                if (bundle != null) {
                    bc = bundle.getBundleContext();
                    SlingRepository repo = (SlingRepository)bc.getService(this.repositoryReference);
                    if (repo == null) {
                        this.logger.warn("Cannot login {} because cannot get SlingRepository on behalf of bundle {} ({})", new Object[]{isLoginAdministrative ? "admin" : "service", bundle.getSymbolicName(), bundle.getBundleId()});
                        throw new org.apache.sling.api.resource.LoginException("Repository unavailable");
                    }
                    try {
                        if (isLoginAdministrative) {
                            session = repo.loginAdministrative(null);
                        } else {
                            Object subService = authenticationInfo.get("sling.service.subservice");
                            String subServiceName = subService instanceof String ? (String)subService : null;
                            session = repo.loginService(subServiceName, null);
                        }
                        break block11;
                    }
                    catch (Throwable t) {
                        if (session == null) {
                            bc.ungetService(this.repositoryReference);
                        }
                        throw t;
                    }
                }
                if (isLoginAdministrative) {
                    throw new org.apache.sling.api.resource.LoginException("Calling bundle missing in authentication info");
                }
                Credentials credentials = JcrProviderStateFactory.getCredentials(authenticationInfo);
                session = this.repository.login(credentials, null);
            }
            catch (RepositoryException re) {
                throw JcrProviderStateFactory.getLoginException(re);
            }
        }
        return this.createJcrProviderState(session, true, authenticationInfo, bc);
    }

    private JcrProviderState createJcrProviderState(@Nonnull Session s, boolean logoutSession, @Nonnull Map<String, Object> authenticationInfo, @Nullable BundleContext ctx) throws org.apache.sling.api.resource.LoginException {
        Session session = JcrProviderStateFactory.handleImpersonation(s, authenticationInfo, logoutSession);
        HelperData data = new HelperData(this.dynamicClassLoaderManagerReference, this.uriProviderReference);
        return new JcrProviderState(session, data, logoutSession, ctx, ctx == null ? null : this.repositoryReference);
    }

    private static Session handleImpersonation(Session session, Map<String, Object> authenticationInfo, boolean logoutSession) throws org.apache.sling.api.resource.LoginException {
        String sudoUser = JcrProviderStateFactory.getSudoUser(authenticationInfo);
        if (sudoUser != null && !session.getUserID().equals(sudoUser)) {
            try {
                SimpleCredentials creds = new SimpleCredentials(sudoUser, new char[0]);
                JcrProviderStateFactory.copyAttributes(creds, authenticationInfo);
                creds.setAttribute("user.impersonator", (Object)session.getUserID());
                Session session2 = session.impersonate((Credentials)creds);
                return session2;
            }
            catch (RepositoryException re) {
                throw JcrProviderStateFactory.getLoginException(re);
            }
            finally {
                if (logoutSession) {
                    session.logout();
                }
            }
        }
        return session;
    }

    private static org.apache.sling.api.resource.LoginException getLoginException(RepositoryException re) {
        if (re instanceof LoginException) {
            return new org.apache.sling.api.resource.LoginException(re.getMessage(), re.getCause());
        }
        return new org.apache.sling.api.resource.LoginException("Unable to login " + re.getMessage(), (Throwable)re);
    }

    private static Credentials getCredentials(Map<String, Object> authenticationInfo) {
        Credentials creds = null;
        if (authenticationInfo != null) {
            Object credentialsObject = authenticationInfo.get("user.jcr.credentials");
            if (credentialsObject instanceof Credentials) {
                creds = (Credentials)credentialsObject;
            } else {
                Object userId = authenticationInfo.get("user.name");
                if (userId instanceof String) {
                    Object password = authenticationInfo.get("user.password");
                    SimpleCredentials credentials = new SimpleCredentials((String)userId, password instanceof char[] ? (char[])password : new char[]{});
                    JcrProviderStateFactory.copyAttributes(credentials, authenticationInfo);
                    creds = credentials;
                }
            }
        }
        if (creds instanceof SimpleCredentials && authenticationInfo.get("user.newpassword") instanceof String) {
            ((SimpleCredentials)creds).setAttribute("user.newpassword", authenticationInfo.get("user.newpassword"));
        }
        return creds;
    }

    private static void copyAttributes(SimpleCredentials target, Map<String, Object> source) {
        for (Map.Entry<String, Object> current : source.entrySet()) {
            if (!JcrProviderStateFactory.isAttributeVisible(current.getKey())) continue;
            target.setAttribute(current.getKey(), current.getValue());
        }
    }

    private static boolean isAttributeVisible(String name) {
        return !name.equals("user.jcr.credentials") && !name.contains("password");
    }

    private static String getSudoUser(Map<String, Object> authenticationInfo) {
        Object sudoObject = authenticationInfo.get("user.impersonation");
        if (sudoObject instanceof String) {
            return (String)sudoObject;
        }
        return null;
    }

    private static Session getSession(Map<String, Object> authenticationInfo) {
        Object sessionObject = authenticationInfo.get("user.jcr.session");
        if (sessionObject instanceof Session) {
            return (Session)sessionObject;
        }
        return null;
    }
}

