/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.jcr.resource.internal.JcrListenerBaseConfig;
import org.apache.sling.jcr.resource.internal.JcrResourceChange;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;

public class JcrResourceListener
implements EventListener,
Closeable {
    private volatile ObserverConfiguration config;
    private final JcrListenerBaseConfig baseConfig;

    public JcrResourceListener(JcrListenerBaseConfig listenerConfig, ObserverConfiguration config) throws RepositoryException {
        this.baseConfig = listenerConfig;
        this.config = config;
        this.baseConfig.register(this, config);
    }

    public void update(ObserverConfiguration cfg) {
        this.config = cfg;
    }

    public ObserverConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void close() throws IOException {
        this.baseConfig.unregister(this);
    }

    public void onEvent(EventIterator events) {
        HashMap<String, ResourceChange> addedEvents = new HashMap<String, ResourceChange>();
        HashMap<String, ResourceChange> changedEvents = new HashMap<String, ResourceChange>();
        HashMap<String, ResourceChange> removedEvents = new HashMap<String, ResourceChange>();
        while (events.hasNext()) {
            String path;
            String identifier;
            Event event = events.nextEvent();
            try {
                identifier = event.getIdentifier();
                path = event.getPath();
            }
            catch (RepositoryException e) {
                continue;
            }
            String eventPath = identifier != null && identifier.startsWith("/") ? identifier : path;
            int type = event.getType();
            if (type == 4 && path.endsWith("/jcr:primaryType")) {
                int lastSlash = path.lastIndexOf(47);
                String rsrcPath = path.substring(0, lastSlash);
                changedEvents.remove(rsrcPath);
                addedEvents.put(rsrcPath, this.createResourceChange(event, rsrcPath, ResourceChange.ChangeType.ADDED));
                continue;
            }
            if (type == 4 || type == 8 || type == 16) {
                String rsrcPath;
                if (identifier == null || !identifier.startsWith("/")) {
                    int lastSlash = eventPath.lastIndexOf(47);
                    rsrcPath = eventPath.substring(0, lastSlash);
                } else {
                    rsrcPath = eventPath;
                }
                if (addedEvents.containsKey(rsrcPath) || removedEvents.containsKey(rsrcPath) || changedEvents.containsKey(rsrcPath)) continue;
                changedEvents.put(rsrcPath, this.createResourceChange(event, rsrcPath, ResourceChange.ChangeType.CHANGED));
                continue;
            }
            if (type == 1) {
                changedEvents.remove(eventPath);
                addedEvents.put(eventPath, this.createResourceChange(event, eventPath, ResourceChange.ChangeType.ADDED));
                continue;
            }
            if (type != 2) continue;
            addedEvents.remove(eventPath);
            changedEvents.remove(eventPath);
            removedEvents.put(eventPath, this.createResourceChange(event, eventPath, ResourceChange.ChangeType.REMOVED));
        }
        ArrayList changes = new ArrayList();
        changes.addAll(addedEvents.values());
        changes.addAll(removedEvents.values());
        changes.addAll(changedEvents.values());
        this.baseConfig.getReporter().reportChanges(this.config, changes, false);
    }

    private ResourceChange createResourceChange(Event event, String path, ResourceChange.ChangeType changeType) {
        String fullPath = path;
        boolean isExternal = this.isExternal(event);
        String userId = !isExternal ? event.getUserID() : null;
        return new JcrResourceChange(changeType, fullPath, isExternal, userId);
    }

    private boolean isExternal(Event event) {
        if (event instanceof JackrabbitEvent) {
            JackrabbitEvent jEvent = (JackrabbitEvent)event;
            return jEvent.isExternal();
        }
        return false;
    }

    public String toString() {
        return "JcrResourceListener [" + this.config + "]";
    }
}

