/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.jcr.resource.internal.helper.Converter;

public class NumberConverter
implements Converter {
    private final Number value;

    public NumberConverter(Number val) {
        this.value = val;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Long toLong() {
        return this.value.longValue();
    }

    @Override
    public Byte toByte() {
        return this.value.byteValue();
    }

    @Override
    public Short toShort() {
        return this.value.shortValue();
    }

    @Override
    public Integer toInteger() {
        return this.value.intValue();
    }

    @Override
    public Double toDouble() {
        return this.value.doubleValue();
    }

    @Override
    public Float toFloat() {
        return Float.valueOf(this.value.floatValue());
    }

    @Override
    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.toLong());
        return c;
    }

    @Override
    public Date toDate() {
        return new Date(this.toLong());
    }

    @Override
    public Boolean toBoolean() {
        return false;
    }

    @Override
    public BigDecimal toBigDecimal() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return new BigDecimal(this.value.toString());
    }
}

