/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.serviceusermapping.ServiceUserValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling JCR System User Validator", description="Enforces the usage of JCR system users for all user mappings being used in the 'Sling Service User Mapper Service'", metatype=true)
@Service(value={ServiceUserValidator.class})
public class JcrSystemUserValidator
implements ServiceUserValidator {
    private final Logger log = LoggerFactory.getLogger(JcrSystemUserValidator.class);
    @Reference
    private volatile SlingRepository repository;
    public static final boolean PROP_ALLOW_ONLY_SYSTEM_USERS_DEFAULT = true;
    @Property(boolValue={true}, label="Allow only JCR System Users", description="If set to true, only user IDs bound to JCR system users are allowed in the user mappings of the 'Sling Service User Mapper Service'. Otherwise all users are allowed!")
    public static final String PROP_ALLOW_ONLY_SYSTEM_USERS = "allow.only.system.user";
    private final Method isSystemUserMethod;
    private final Set<String> validIds = new CopyOnWriteArraySet<String>();
    private boolean allowOnlySystemUsers;

    public JcrSystemUserValidator() {
        Method m = null;
        try {
            m = User.class.getMethod("isSystemUser", new Class[0]);
        }
        catch (Exception e) {
            this.log.debug("Exception while accessing isSystemUser method", (Throwable)e);
        }
        this.isSystemUserMethod = m;
    }

    @Activate
    public void activate(Map<String, Object> config) {
        this.allowOnlySystemUsers = PropertiesUtil.toBoolean((Object)config.get(PROP_ALLOW_ONLY_SYSTEM_USERS), (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(String serviceUserId, String serviceName, String subServiceName) {
        block8: {
            boolean bl;
            if (serviceUserId == null) {
                this.log.debug("The provided service user id is null");
                return false;
            }
            if (!this.allowOnlySystemUsers) {
                this.log.debug("There is no enforcement of JCR system users, therefore service user id '{}' is valid", (Object)serviceUserId);
                return true;
            }
            if (this.validIds.contains(serviceUserId)) {
                this.log.debug("The provided service user id '{}' has been already validated and is a known JCR system user id", (Object)serviceUserId);
                return true;
            }
            Session administrativeSession = null;
            try {
                UserManager userManager;
                Authorizable authorizable;
                administrativeSession = this.repository.loginAdministrative(null);
                if (!(administrativeSession instanceof JackrabbitSession) || (authorizable = (userManager = ((JackrabbitSession)administrativeSession).getUserManager()).getAuthorizable(serviceUserId)) == null || authorizable.isGroup() || !this.isSystemUser((User)authorizable)) break block8;
                this.validIds.add(serviceUserId);
                this.log.debug("The provided service user id {} is a known JCR system user id", (Object)serviceUserId);
                bl = true;
                if (administrativeSession == null) return bl;
            }
            catch (RepositoryException e) {
                this.log.warn("Could not get user information", (Throwable)e);
                break block8;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            administrativeSession.logout();
            return bl;
        }
        this.log.warn("The provided service user id '{}' is not a known JCR system user id and therefore not allowed in the Sling Service User Mapper.", (Object)serviceUserId);
        return false;
    }

    private boolean isSystemUser(User user) {
        if (this.isSystemUserMethod != null) {
            try {
                return (Boolean)this.isSystemUserMethod.invoke((Object)user, new Object[0]);
            }
            catch (Exception e) {
                this.log.debug("Exception while invoking isSystemUser method", (Throwable)e);
                return true;
            }
        }
        return true;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

